dnl Checks for package, version, library interface version.
dnl CF_CHECK_VERSION(VERSION-FILE-NAME [, LT-VERSION-FILE-NAME])
AC_DEFUN(CF_CHECK_VERSION, [
  if test -f "${srcdir}/$1"; then :; else
    AC_MSG_ERROR(Missing version file.)
  fi
  AC_MSG_CHECKING(package name)
  PACKAGE=`sed -n '1s/^\([[^  ]][[^   ]]*\) *version.*$/\1/p' ${srcdir}/$1`
  if test -z "$PACKAGE"; then
    AC_MSG_ERROR(Bad version file.)
  fi
  AC_MSG_RESULT($PACKAGE)
  AC_MSG_CHECKING(version number)
  VERSION=`sed -n '1s/^.*version *\([[0-9.]][[0-9.]]*\).*$/\1/p' ${srcdir}/$1`
  if test -z "$VERSION"; then
    AC_MSG_ERROR(Bad version file.)
  fi
  AC_MSG_RESULT($VERSION)
  AC_MSG_CHECKING(revision string)
  REVISION="`sed -n '1s/^.*version.*(\(.*\))/\1/p' ${srcdir}/$1`"
  test -z "$REVISION" && REVISION=release
  AC_MSG_RESULT($REVISION)
  MAJOR_VERSION=`echo $VERSION | sed -n 's/^\([[0-9]][[0-9]]*\).*/\1/p'`
  MINOR_VERSION=`echo $VERSION | sed -n 's/^[[0-9]][[0-9]]*\.\([[0-9]][[0-9]]*\).*/\1/p'`
  MICRO_VERSION=`echo $VERSION | sed -n 's/^[[0-9]][[0-9]]*\.[[0-9]][[0-9]]*\.\([[0-9]][[0-9]]*\).*/\1/p'`
  MAJOR_VERSION=`expr $MAJOR_VERSION + 0`
  MINOR_VERSION=`expr $MINOR_VERSION + 0`
  MICRO_VERSION=`expr $MICRO_VERSION + 0`
  AC_SUBST(PACKAGE)
  AC_SUBST(VERSION)
  AC_SUBST(REVISION)
  AC_SUBST(MAJOR_VERSION)
  AC_SUBST(MINOR_VERSION)
  AC_SUBST(MICRO_VERSION)
  ifelse("$2","",,[
    if test -f "${srcdir}/$2"; then :; else
      AC_MSG_ERROR(Missing lt-version file.)
    fi
    AC_MSG_CHECKING(library version)
    interface_age=`sed -n '1s/^\([[0-9]][[0-9]]*\)\..*$/\1/p' ${srcdir}/$2`
    binary_age=`sed -n '1s/^.*\.\([[0-9]][[0-9]]*\)$/\1/p' ${srcdir}/$2`
    LT_RELEASE=$MAJOR_VERSION.$MINOR_VERSION
    LT_CURRENT=`expr $MICRO_VERSION - $interface_age`
    LT_REVISION=$interface_age
    LT_AGE=`expr $binary_age - $interface_age`
    AC_MSG_RESULT([release $LT_RELEASE, version ${LT_CURRENT}.${LT_REVISION}.${LT_AGE}])
    AC_SUBST(LT_RELEASE)
    AC_SUBST(LT_CURRENT)
    AC_SUBST(LT_REVISION)
    AC_SUBST(LT_AGE)
  ])
])

dnl Checks for option for specified command.
dnl CF_CHECK_OPTION(PROGRAM-VARIABLE, FLAG-VARIABLE, OPTION)
AC_DEFUN(CF_CHECK_OPTION, [
  changequote(<<,>>)dnl
  define(<<cacheval>>, translit(cf_cv_prog_$1_$3, +-, P_))dnl
  changequote([,])dnl
  AC_CACHE_CHECK(whether [$]$1 accepts $3, cacheval, [
    echo 'int main(void) { return 0; }' > conftest.$ac_ext
    if test -z "`[$]$1 [$]$2 $3 -c conftest.$ac_ext 2>&1`"; then
      cacheval=yes
    else
      cacheval=no
    fi
    rm -fr conftest*
  ])
  if test x$cacheval = xyes; then
    if test ! x"`echo [$]$2 | sed -n 's,.*$3.*,x,p'`" = xx; then
      $2="[$]$2 $3"
    fi
  fi
])

dnl Checks for accept() 3rd argument type.
AC_DEFUN(CF_CHECK_ACCEPT_THIRD_ARG, [
  AC_CACHE_CHECK(whether accept 3rd arg is unsigned, cf_cv_func_accept_arg, [
    AC_TRY_COMPILE([
#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#if HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
    ]ifelse(AC_LANG, CPLUSPLUS, [
#ifdef __cplusplus
extern "C"
#endif
    ]),[ struct sockaddr a; int b; accept(0, &a, &b); ],
    eval "cf_cv_func_accept_arg=no", eval "cf_cv_func_accept_arg=yes")
  ])
  if test x"$cf_cv_func_accept_arg" = xyes; then
    AC_DEFINE_UNQUOTED(ACCEPT_THIRD_ARG_IS_UNSIGNED)
  fi
])

dnl Checks for recvfrom() 6th argument type.
AC_DEFUN(CF_CHECK_RECVFROM_SIXTH_ARG, [
  AC_CACHE_CHECK(whether recvfrom 6th arg is unsigned,
                 cf_cv_func_recvfrom_arg, [
    AC_TRY_COMPILE([
#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#if HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
    ]ifelse(AC_LANG, CPLUSPLUS, [
#ifdef __cplusplus
extern "C"
#endif
    ]),[ struct sockaddr a; int b; char c; recvfrom(0, &c, 1, 0, &a, &b); ],
    eval "cf_cv_func_recvfrom_arg=no", eval "cf_cv_func_recvfrom_arg=yes")
  ])
  if test x"$cf_cv_func_recvfrom_arg" = xyes; then
    AC_DEFINE_UNQUOTED(RECVFROM_SIXTH_ARG_IS_UNSIGNED)
  fi
])

dnl Checks for fpsetmask function.
AC_DEFUN(CF_CHECK_FPSETMASK, [
  AC_CACHE_CHECK(for fpsetmask, cf_cv_func_fpsetmask, [
    AC_TRY_LINK([
#if HAVE_FLOATINGPOINT_H
# include <floatingpoint.h>
#endif /* HAVE_FLOATINGPOINT_H */
#if HAVE_IEEEFP_H
# include <ieeefp.h>
#endif /* HAVE_IEEEFP_H */
    ]ifelse(AC_LANG, CPLUSPLUS, [
#ifdef __cplusplus
extern "C"
#endif
    ]),
    [fpsetmask(0);],
    eval "cf_cv_func_fpsetmask=yes", eval "cf_cv_func_fpsetmask=no")
  ])
  if test x"$cf_cv_func_fpsetmask" = xyes; then
    AC_DEFINE_UNQUOTED(HAVE_FPSETMASK)
  fi
])

dnl Checks for htons function.
AC_DEFUN(CF_CHECK_HTONS, [
  AC_CACHE_CHECK(for htons, cf_cv_func_htons, [
    AC_TRY_LINK([
#if HAVE_UNISTD_H
# include <unistd.h>
#endif /* HAVE_UNISTD_H */
#if HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif /* HAVE_NETINET_IN_H */
#if HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif /* HAVE_SYS_PARAM_H */
    ]ifelse(AC_LANG, CPLUSPLUS, [
#ifdef __cplusplus
extern "C"
#endif
    ]), [htons(0);],
    eval "cf_cv_func_htons=yes", eval "cf_cv_func_htons=no")
  ])
  if test x"$cf_cv_func_htons" = xyes; then
    AC_DEFINE_UNQUOTED(HAVE_HTONS)
  fi
])

dnl Checks for math function.
dnl CF_CHECK_MATH_FUNC(FUNCTION-NAME)
AC_DEFUN(CF_CHECK_MATH_FUNC, [
  AC_CACHE_CHECK(for $1, cf_cv_func_$1, [
    AC_TRY_LINK([
#include <math.h>
    ],[$1($2);],
    eval "cf_cv_func_$1=yes", eval "cf_cv_func_$1=no")
  ])
  if test x"$cf_cv_func_$1" = xyes; then
    ac_tr_func=HAVE_`echo $1 | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
    AC_DEFINE_UNQUOTED($ac_tr_func)
    ifelse([$3], , :, [$3])
  else
    ifelse([$4], , :, [$4])
  fi
])
# Configure paths for GTK+
# Owen Taylor     97-11-3

dnl ---- took from gtk.m4 ----
dnl AM_PATH_GTK([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for GTK, and define GTK_CFLAGS and GTK_LIBS
dnl
AC_DEFUN(AM_PATH_GTK,
[dnl 
dnl Get the cflags and libraries from the gtk-config script
dnl
AC_ARG_WITH(gtk-prefix,[  --with-gtk-prefix=PFX   Prefix where GTK is installed (optional)],
            gtk_config_prefix="$withval", gtk_config_prefix="")
AC_ARG_WITH(gtk-exec-prefix,[  --with-gtk-exec-prefix=PFX Exec prefix where GTK is installed (optional)],
            gtk_config_exec_prefix="$withval", gtk_config_exec_prefix="")
AC_ARG_ENABLE(gtktest, [  --disable-gtktest       Do not try to compile and run a test GTK program],
		    , enable_gtktest=yes)

  for module in . $4
  do
      case "$module" in
         gthread) 
             gtk_config_args="$gtk_config_args gthread"
         ;;
      esac
  done

  if test x$gtk_config_exec_prefix != x ; then
     gtk_config_args="$gtk_config_args --exec-prefix=$gtk_config_exec_prefix"
     if test x${GTK_CONFIG+set} != xset ; then
        GTK_CONFIG=$gtk_config_exec_prefix/bin/gtk-config
     fi
  fi
  if test x$gtk_config_prefix != x ; then
     gtk_config_args="$gtk_config_args --prefix=$gtk_config_prefix"
     if test x${GTK_CONFIG+set} != xset ; then
        GTK_CONFIG=$gtk_config_prefix/bin/gtk-config
     fi
  fi

  AC_PATH_PROG(GTK_CONFIG, gtk-config, no)
  min_gtk_version=ifelse([$1], ,0.99.7,$1)
  AC_MSG_CHECKING(for GTK - version >= $min_gtk_version)
  no_gtk=""
  if test "$GTK_CONFIG" = "no" ; then
    no_gtk=yes
  else
    GTK_CFLAGS=`$GTK_CONFIG $gtk_config_args --cflags`
    GTK_LIBS=`$GTK_CONFIG $gtk_config_args --libs`
    gtk_config_major_version=`$GTK_CONFIG $gtk_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    gtk_config_minor_version=`$GTK_CONFIG $gtk_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    gtk_config_micro_version=`$GTK_CONFIG $gtk_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_gtktest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $GTK_CFLAGS"
      LIBS="$GTK_LIBS $LIBS"
dnl
dnl Now check if the installed GTK is sufficiently new. (Also sanity
dnl checks the results of gtk-config to some extent
dnl
      rm -f conf.gtktest
      AC_TRY_RUN([
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.gtktest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_gtk_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_gtk_version");
     exit(1);
   }

  if ((gtk_major_version != $gtk_config_major_version) ||
      (gtk_minor_version != $gtk_config_minor_version) ||
      (gtk_micro_version != $gtk_config_micro_version))
    {
      printf("\n*** 'gtk-config --version' returned %d.%d.%d, but GTK+ (%d.%d.%d)\n", 
             $gtk_config_major_version, $gtk_config_minor_version, $gtk_config_micro_version,
             gtk_major_version, gtk_minor_version, gtk_micro_version);
      printf ("*** was found! If gtk-config was correct, then it is best\n");
      printf ("*** to remove the old version of GTK+. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If gtk-config was wrong, set the environment variable GTK_CONFIG\n");
      printf("*** to point to the correct copy of gtk-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
#if defined (GTK_MAJOR_VERSION) && defined (GTK_MINOR_VERSION) && defined (GTK_MICRO_VERSION)
  else if ((gtk_major_version != GTK_MAJOR_VERSION) ||
	   (gtk_minor_version != GTK_MINOR_VERSION) ||
           (gtk_micro_version != GTK_MICRO_VERSION))
    {
      printf("*** GTK+ header files (version %d.%d.%d) do not match\n",
	     GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     gtk_major_version, gtk_minor_version, gtk_micro_version);
    }
#endif /* defined (GTK_MAJOR_VERSION) ... */
  else
    {
      if ((gtk_major_version > major) ||
        ((gtk_major_version == major) && (gtk_minor_version > minor)) ||
        ((gtk_major_version == major) && (gtk_minor_version == minor) && (gtk_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of GTK+ (%d.%d.%d) was found.\n",
               gtk_major_version, gtk_minor_version, gtk_micro_version);
        printf("*** You need a version of GTK+ newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** GTK+ is always available from ftp://ftp.gtk.org.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the gtk-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of GTK+, but you can also set the GTK_CONFIG environment to point to the\n");
        printf("*** correct copy of gtk-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_gtk=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_gtk" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$GTK_CONFIG" = "no" ; then
       echo "*** The gtk-config script installed by GTK could not be found"
       echo "*** If GTK was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the GTK_CONFIG environment variable to the"
       echo "*** full path to gtk-config."
     else
       if test -f conf.gtktest ; then
        :
       else
          echo "*** Could not run GTK test program, checking why..."
          CFLAGS="$CFLAGS $GTK_CFLAGS"
          LIBS="$LIBS $GTK_LIBS"
          AC_TRY_LINK([
#include <gtk/gtk.h>
#include <stdio.h>
],      [ return ((gtk_major_version) || (gtk_minor_version) || (gtk_micro_version)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding GTK or finding the wrong"
          echo "*** version of GTK. If it is not finding GTK, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***"
          echo "*** If you have a RedHat 5.0 system, you should remove the GTK package that"
          echo "*** came with the system with the command"
          echo "***"
          echo "***    rpm --erase --nodeps gtk gtk-devel" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means GTK was incorrectly installed"
          echo "*** or that you have moved GTK since it was installed. In the latter case, you"
          echo "*** may want to edit the gtk-config script: $GTK_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     GTK_CFLAGS=""
     GTK_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(GTK_CFLAGS)
  AC_SUBST(GTK_LIBS)
  rm -f conf.gtktest
])
