/* -*- C++ -*-
 * Copyright (c) 1998 Keisuke Inoue, Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */
/*
 * <<< big_word.h >>>
 * Х򹭤bus_portǻꤹ
 */

#ifndef BIG_WORD_H
#define BIG_WORD_H

#include <algorithm>
#include <iostream>
#include <iomanip>
#include <vector>

template <class T>
class big_word : public vector<T>
{
private:
	typedef vector<T> inherited;
public:
	big_word();
	~big_word();
	size_t size() const {
		return inherited::size(); }
	void resize(size_t);
	bool compare(const big_word<T>&) const;
	void output(ostream&) const;
};

template <class T>
big_word<T>::big_word()
{
}

template <class T>
big_word<T>::~big_word()
{
}

template <class T>
void big_word<T>::resize(size_t a)
{
	inherited::resize(a);
	fill(begin(), end(), T(0));
}

template <class T>
bool big_word<T>::compare(const big_word<T>& a) const
{
	if (size() != a.size())
		return false;

	for (size_t i = 0; i < size(); i++) {
		if ((*this)[i] != a[i])
			return false;
	}
	return true;
}

template <class T>
inline int operator==(const big_word<T>& a, const big_word<T>& b)
{
	return a.compare(b);
}

template <class T>
inline int operator!=(const big_word<T>& a, const big_word<T>& b)
{
	return !a.compare(b);
}

template <class T>
void big_word<T>::output(ostream& os) const
{
	const char fill = os.fill();
	const long flags = os.flags();
	os << hex << setfill('0');
	for (size_t i = 0; i < size(); i++) {
		if (i) os << ' ';
		os << (*this)[i];
	}
	os.fill(fill);
	os.flags(flags);
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

template <class T>
ostream& operator<<(ostream& os, const big_word<T>& a)
{
	if (os) a.output(os);
#ifdef DEBUG
	os.flush();
#endif // DEBUG
	return os;
}

#endif // BIG_WORD_H
