/*
 * <<< debugger_test.cc >>>
 *
 * --- Test program for debugger
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include <list>
#include "isis.h"
#include "r3000_processing_element.h"
#include "debugger.h"

int main(int, char** argv)
{
	typedef r3000_processing_element processing_element_type;
	typedef processing_element_type::address_type address_type;
	if (argv[1] == NULL) {
		cerr << "No executable file specified." << endl;
		return 1;
	}
	debugger<processing_element_type> mon;
	processing_element_type pe;
	pe.set_local_memory_area(0, 0x10000000);
	if (!pe.load(argv[1])) {
		cerr << argv[1] << ": No such file or directory." << endl;
		return 1;
	}
	pe.set_instruction_cache_size(0x2000, 0x10);
	pe.set_data_cache_size(0x2000, 0x10);
	pe.set_file_table_size(16);
	pe.set_standard_input_stream(cin);
	pe.set_standard_output_stream(cout);
	pe.set_standard_error_stream(cerr);
	pe.set_commandline_argument((const char* const*)(argv + 1));
	mon.set(pe);
	cout << hex;
	// memory access test
	{
		mon.dump(cout, pe.processor().program_counter(), 0x20);
		mon.disassemble(cout, pe.processor().program_counter(), 0x20);
	}
	// breakpoint test
	{
		typedef list<address_type> container_type;
		typedef container_type::const_iterator CI;
		mon.insert_breakpoint(pe.processor().program_counter() + 0x10);
		mon.insert_breakpoint(pe.processor().program_counter() + 0x20);
		container_type buf;
		mon.dump_breakpoints(buf);
		cout << "breakpoints:";
		for (CI p = buf.begin(); p != buf.end(); p++) {
			cout << " 0x" << *p;
		}
		cout << endl;
	}
	// execute test
	{
		while (!mon.is_halt() && !mon.is_bus_error()) {
			mon.execute();
			cout << "break at 0x" << pe.processor().program_counter()
				 << ", time:0x" << pe.timer_clock_value() << endl;
		}
	}
	return 0;
}
