/*
 * <<< timer_unit_test.cc >>>
 *
 * --- Test program for timer_unit class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include "timer_unit.h"
#include "bus_port.h"

int main(void)
{
	timer_unit<unsigned> timer(0x100);
	bus_port<unsigned> bus_if;
	timer.port_ref().connect(bus_if);
	bus_if.send_single_read_request(0x100);
	while (!bus_if.is_ready()) {
		cout << timer << ": " << bus_if << endl;
		timer.clock_in();
		int flag = (bus_if.is_data());
		timer.clock_out();
		if (flag) bus_if.clear();
	}
	return 0;
}
