/*
 * <<< integer_hash_map_test.cc >>>
 *
 * --- Test program for integer_hash_map class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstddef>
#include "integer_hash_map.h"

int main(void)
{
	typedef integer_hash_map<int, int> container_type;
	const size_t count = 50, hash_size = 19;
	container_type buf;
	size_t i;
	// write
	buf.resize(hash_size);
	for (i = 0; i < count; i++) buf[i] = i + 100;
	// expand
	buf.resize(hash_size * 2 - 1);
	// copy
	container_type buf2(buf);
	// shrink
	buf2.resize(hash_size);
	// check
	for (i = 0; i < count; i++) {
		if (buf[i] != int(i + 100)) return 1;
	}
	return 0;
}
