/* -*- C++ -*-
 *
 * <<< r3081_processing_element.h >>>
 *
 * --- R3081 processing element class 'r3081_processing_element'
 *     Copyright (C) 1997-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3081_PROCESSING_ELEMENT_H
#define R3081_PROCESSING_ELEMENT_H 1

#include <string>
#include "generic_processing_element.h"
#include "r3000_typedef.h"
#include "r3081.h"

class ostream;

class r3081_processing_element
	: public generic_processing_element<r3081, r3000_word, r3000_word,
										sizeof_r3000_word, char>
{
private:
	typedef r3081_processing_element thisclass;
	typedef generic_processing_element<r3081, r3000_word, r3000_word,
									   sizeof_r3000_word, char> inherited;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	typedef inherited::char_type char_type;
	typedef inherited::size_type size_type;
	static const size_type sizeof_data_type = inherited::sizeof_data_type;
private:
	static const address_type default_multi_io_area_address;
	static const size_type default_multi_io_area_size;
public:
	r3081_processing_element(void);
	r3081_processing_element(const thisclass&);
	virtual ~r3081_processing_element();
	virtual void output(ostream&) const;
	virtual bool output(ostream&, const string&) const;
	virtual bool load(const char*);
	virtual void disassemble(ostream&, const address_type&, const size_type&)
		const;
	void enable_coprocessor(void) { pu.enable_coprocessor(); }
	void enable_instruction_cache(void) { pu.enable_instruction_cache(); }
	void enable_data_cache(void) { pu.enable_instruction_cache(); }
	void disable_coprocessor(void) { pu.disable_coprocessor(); }
	void disable_instruction_cache(void) { pu.disable_instruction_cache(); }
	void disable_data_cache(void) { pu.disable_data_cache(); }
};

#endif /* R3081_PROCESSING_ELEMENT_H */
