/*
 * <<< sysfloat.cc >>>
 *
 * --- Copyright (C) 1996-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#if HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */
#ifndef __EXTENSIONS__ /* for Solaris2.6 */
# define __EXTENSIONS__
#endif /* __EXTENSIONS__ */
#ifndef _GNU_SOURCE /* for Linux */
# define _GNU_SOURCE
#endif /* _GNU_SOURCE */
#ifndef _HPUX_SOURCE /* for HPUX */
# define _HPUX_SOURCE
#endif /* _HPUX_SOURCE */
#include <cmath>
#include "r3010_global.h"
#include "sysfloat.h"
#include "r3010_float.h"

#define R3000_WORD_LENGTH		  32
#define R3000_FLOAT_MAX_EXP		 128
#define R3000_FLOAT_MANT_DIG	  24
#define R3000_DOUBLE_MAX_EXP	1024
#define R3000_DOUBLE_MANT_DIG	  53

#if SINGLE_FLOAT_MAX_EXP != R3000_FLOAT_MAX_EXP || \
	DOUBLE_FLOAT_MAX_EXP != R3000_DOUBLE_MAX_EXP || \
	SINGLE_FLOAT_MANT_DIG != R3000_FLOAT_MANT_DIG || \
	DOUBLE_FLOAT_MANT_DIG != R3000_DOUBLE_MANT_DIG
# error "Sorry, different float variable type was not supported."
#endif

#define SINGLE_FLOAT_FRAC_MASK \
	(~(~0L << (SINGLE_FLOAT_MANT_DIG - 1)))
#define DOUBLE_FLOAT_FRAC_MASK_HI \
	(~(~0L << (DOUBLE_FLOAT_MANT_DIG - R3000_WORD_LENGTH - 1)))
#define SINGLE_FLOAT_EXP_BASE (SINGLE_FLOAT_MAX_EXP - 1)
#define DOUBLE_FLOAT_EXP_BASE (DOUBLE_FLOAT_MAX_EXP - 1)
#define SINGLE_FLOAT_EXP_SHIFT (SINGLE_FLOAT_MANT_DIG - 1)
#define DOUBLE_FLOAT_EXP_SHIFT_HI \
	(DOUBLE_FLOAT_MANT_DIG - R3000_WORD_LENGTH - 1)

/* setup for float copysign() */
#if S_FLOAT_IS_FLOAT /* s_float is float */
# if HAVE_COPYSIGNF
#  define s_copysign copysignf
# elif HAVE_COPYSIGN
#  define s_copysign copysign
# else
#  error "Can't find copysign() function."
# endif
#else /* s_float is double */
# if HAVE_COPYSIGN
#  define s_copysign copysign
# else
#  error "Can't find copysign() function."
# endif
#endif

/* setup for double copysign() */
#if D_FLOAT_IS_FLOAT /* d_float is float */
# if HAVE_COPYSIGNF
#  define d_copysign copysignf
# elif HAVE_COPYSIGN
#  define d_copysign copysign
# else
#  error "Can't find copysign() function."
# endif
#else /* d_float is double */
# if HAVE_COPYSIGN
#  define d_copysign copysign
# else
#  error "Can't find copysign() function."
# endif
#endif

/* setup for float ilogb() */
#if S_FLOAT_IS_FLOAT /* s_float is float */
# if HAVE_ILOGBF
#  define s_ilogb ilogbf
# elif HAVE_ILOGB
#  define s_ilogb ilogb
# else
#  error "Can't find ilogb() function."
# endif
#else /* s_float is double */
# if HAVE_ILOGB
#  define s_ilogb ilogb
# else
#  error "Can't find ilogb() function."
# endif
#endif

/* setup for double ilogb() */
#if D_FLOAT_IS_FLOAT /* d_float is float */
# if HAVE_ILOGBF
#  define d_ilogb ilogbf
# elif HAVE_ILOGB
#  define d_ilogb ilogb
# else
#  error "Can't find ilogb() function."
# endif
#else /* d_float is double */
# if HAVE_ILOGB
#  define d_ilogb ilogb
# else
#  error "Can't find ilogb() function."
# endif
#endif

/* setup for float scalbn() */
#if S_FLOAT_IS_FLOAT /* s_float is float */
# if HAVE_SCALBNF
#  define s_scalbn scalbnf
# elif HAVE_SCALBN
#  define s_scalbn scalbn
# elif HAVE_LDEXP
#  define s_scalbn ldexp
# else
#  error "Can't find scalbn() and ldexp() function."
# endif
#else /* s_float is double */
# if HAVE_SCALBN
#  define s_scalbn scalbn
# elif HAVE_LDEXP
#  define s_scalbn ldexp
# else
#  error "Can't find scalbn() and ldexp() function."
# endif
#endif

/* setup for double scalbn() */
#if D_FLOAT_IS_FLOAT /* d_float is float */
# if HAVE_SCALBNF
#  define d_scalbn scalbnf
# elif HAVE_SCALBN
#  define d_scalbn scalbn
# elif HAVE_LDEXP
#  define d_scalbn ldexp
# else
#  error "Can't find scalbn() and ldexp() function."
# endif
#else /* d_float is double */
# if HAVE_SCALBN
#  define d_scalbn scalbn
# elif HAVE_LDEXP
#  define d_scalbn ldexp
# else
#  error "Can't find scalbn() and ldexp() function."
# endif
#endif

int get_sign(s_float a)
{
	return (s_copysign(1, a) < 0) ? 1 : 0;
}

int get_sign(d_float a)
{
	return (d_copysign(1, a) < 0) ? 1 : 0;
}

int get_exp(s_float a)
{
	return s_ilogb(a);
}

int get_exp(d_float a)
{
	return d_ilogb(a);
}

void get_frac(s_float a, r3000_word frac[2])
{
	union { s_float f; r3000_word w; } data;
	data.f = a;
	frac[0] = data.w & SINGLE_FLOAT_FRAC_MASK;
	frac[1] = 0;
}

void get_frac(d_float a, r3000_word frac[2])
{
	union { d_float f; r3000_word w[2]; } data;
	data.f = a;
#	if WORDS_BIGENDIAN
		/* big-endian */
		frac[0] = data.w[0] & DOUBLE_FLOAT_FRAC_MASK_HI;
		frac[1] = data.w[1];
#	else
		/* little-endian */
		frac[0] = data.w[1] & DOUBLE_FLOAT_FRAC_MASK_HI;
		frac[1] = data.w[0];
#	endif
}

void make_single(s_float& val, int sign, int exp, r3000_word frac)
{
	union { s_float f; r3000_word w; } data;
	if (exp == INT_MIN) {
		data.f = 0;
	} else if (exp == INT_MAX) {
		/* infinity */
		volatile s_float tmp = SINGLE_FLOAT_MAX;
		data.f = tmp + SINGLE_FLOAT_MAX;
	} else {
		data.w = (frac & SINGLE_FLOAT_FRAC_MASK)
					| (SINGLE_FLOAT_EXP_BASE << SINGLE_FLOAT_EXP_SHIFT);
		data.f = s_scalbn(data.f, exp);
	}
	val = s_copysign(data.f, sign ? -1 : 1);
}

void make_double(d_float& val, int sign, int exp, r3000_word frac[2])
{
	union { d_float f; r3000_word w[2]; } data;
	if (exp == INT_MIN) {
		data.f = 0;
	} else if (exp == INT_MAX) {
		volatile d_float tmp = DOUBLE_FLOAT_MAX;
		data.f = tmp + DOUBLE_FLOAT_MAX; /* infinity */
	} else {
#		if WORDS_BIGENDIAN
			/* big-endian */
			data.w[0] = (frac[0] & DOUBLE_FLOAT_FRAC_MASK_HI)
						| (DOUBLE_FLOAT_EXP_BASE << DOUBLE_FLOAT_EXP_SHIFT_HI);
			data.w[1] = frac[1];
#		else
			/* little-endian */
			data.w[0] = frac[1];
			data.w[1] = (frac[0] & DOUBLE_FLOAT_FRAC_MASK_HI)
						| (DOUBLE_FLOAT_EXP_BASE << DOUBLE_FLOAT_EXP_SHIFT_HI);
#		endif
		data.f = d_scalbn(data.f, exp);
	}
	val = d_copysign(data.f, sign ? -1 : 1);
}
