/*
 * <<< r3010_float.cc >>>
 *
 * --- Copyright (C) 1996-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "r3010_global.h"
#include "sysfloat.h"
#include "r3010_float.h"

void
r3010_word_to_single( r3000_word w, s_float& f )
{
	int sign, exp;
	r3000_word frac;

	sign = (w >> SINGLE_SIGN_SHIFT) & SINGLE_SIGN_MASK;
	exp = (w >> SINGLE_EXP_SHIFT) & SINGLE_EXP_MASK;
	frac = (w >> SINGLE_FRAC_SHIFT) & SINGLE_FRAC_MASK;

	exp -= SINGLE_EXP_BASE;
	if( exp > SINGLE_EXP_MAX )
		exp = EXP_INFINITY;
	else if( exp < SINGLE_EXP_MIN )
		exp = EXP_ZERO;

	make_single( f, sign, exp, frac );
}

void
r3010_word_to_double( r3000_word w[2], d_float& d )
{
	int sign, exp;
	r3000_word frac[2];

	sign = (w[1] >> (DOUBLE_SIGN_SHIFT-32)) & DOUBLE_SIGN_MASK;
	exp = (w[1] >> (DOUBLE_EXP_SHIFT-32)) & DOUBLE_EXP_MASK;
	frac[0] = w[1] & DOUBLE_FRAC_HI_MASK;
	frac[1] = w[0] & DOUBLE_FRAC_LO_MASK;

	exp -= DOUBLE_EXP_BASE;
	if( exp > DOUBLE_EXP_MAX )
		exp = EXP_INFINITY;
	else if( exp < DOUBLE_EXP_MIN )
		exp = EXP_ZERO;

	make_double( d, sign, exp, frac );
}

void
r3010_single_to_word( s_float f, r3000_word& w )
{
	int sign, exp;
	r3000_word frac[2];

	sign = get_sign( f );

	if( f == 0.0 ) {
		exp = EXP_ZERO;
		frac[0] = 0;
	}
	else {
		exp = get_exp( f );
		get_frac( f, frac );
	}

	if( exp == EXP_INFINITY )
		exp = SINGLE_EXP_MAX + 1;
	else if( exp == EXP_ZERO )
		exp = SINGLE_EXP_MIN - 1;
	exp += SINGLE_EXP_BASE;

	w = ( (sign & SINGLE_SIGN_MASK) << SINGLE_SIGN_SHIFT ) |
		( (exp & SINGLE_EXP_MASK) << SINGLE_EXP_SHIFT ) |
		( (frac[0] & SINGLE_FRAC_MASK) << SINGLE_FRAC_SHIFT );
}

void
r3010_double_to_word( d_float f, r3000_word w[2] )
{
	int sign, exp;
	r3000_word frac[2];

	sign = get_sign( f );

	if( f == 0.0 ) {
		exp = EXP_ZERO;
		frac[0] = 0;
		frac[1] = 0;
	}
	else {
		exp = get_exp( f );
		get_frac( f, frac );
	}

	if( exp == EXP_INFINITY )
		exp = DOUBLE_EXP_MAX + 1;
	else if( exp == EXP_ZERO )
		exp = DOUBLE_EXP_MIN - 1;
	exp += DOUBLE_EXP_BASE;

	w[0] = frac[1];
	w[1] =
		( (sign & DOUBLE_SIGN_MASK) << (DOUBLE_SIGN_SHIFT-32) ) |
		( (exp & DOUBLE_EXP_MASK) << (DOUBLE_EXP_SHIFT-32) ) |
		(frac[0] & DOUBLE_FRAC_HI_MASK);
}

/*********************************************************************
 *																	 *
 *  Following two functions are *NOT* to convert precision.			 *
 *																	 *
 *  They are needed at the situation like:							 *
 *	 add.s $f4, $f0, $f2  ($f4 is used as single precision, but..)	 *
 *	 sub.d $f8, $f4, $f6  ($f4 is used as double precision at here!) *
 *********************************************************************/
void
r3010_single_to_double( s_float s[2], d_float& d )
{
	r3000_word w[2];

	r3010_single_to_word( s[0], w[0] );
	r3010_single_to_word( s[1], w[1] );
	r3010_word_to_double( w, d );
}

void
r3010_double_to_single( d_float d, s_float s[2] )
{
	r3000_word w[2];

	r3010_double_to_word( d, w );
	r3010_word_to_single( w[0], s[0] );
	r3010_word_to_single( w[0], s[1] );
}

int
top_one( register r3000_word w )
{
	register int i;

	for( i = -1; w; i++, w >>= 1 )
		;

	return i;
}


#if 0
void
main()
{
	double d, e;
	r3000_word w[2];
	int i;

	for( i = -3; i < 10; i++ ) {
		d = (double)i / 3.1415926536;
		r3010_double_to_word( d, w );
		r3010_word_to_double( w, e );

		cout << i
			<< ":" << d << ":"
			<< hex << setfill('0')
			<< setw(8) << w[0] << " " << setw(8) << w[1]
			<< dec << setfill(' ')
			<< ":" << e
			<< ":" << (d == e ? "EQ" : "NE") << endl;
	}
}
#endif
