/* -*- C++ -*-
 *
 * <<< r3010_fgr.h >>>
 *
 * --- Copyright (C) 1996-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_FGR_H
#define R3010_FGR_H 1

#include "r3010_global.h"
#include "r3010_float.h"

class ostream;

class r3010_fgr
{
	r3000_word w[2];
	s_float s[2];
	d_float d;
	enum { fgr_words, fgr_singles, fgr_double } state;

	friend class debug;
public:
	void reset();

	r3000_word read_word( int idx );
	s_float read_single( int idx );
	d_float read_double();

	void write_word( int idx, r3000_word data );
	void write_single( int idx, s_float data );
	void write_double( d_float data );

	friend ostream& operator<<( ostream&, const r3010_fgr& );
};

class r3010_fgrbuf
{
	r3010_fgr *regs;

	friend class debug;
public:
	r3010_fgrbuf() { regs = new r3010_fgr[NFGR/2]; }
	void reset() { for( int i = 0; i < NFGR/2; i++ ) regs[i].reset(); }

	r3000_word read_word( int regnum ) {
		return regs[regnum/2].read_word(regnum%2);
	}
	s_float read_single( int regnum ) {
		return regs[regnum/2].read_single(regnum%2);
	}
	d_float read_double( int regnum ) {
		return regs[regnum/2].read_double();
	}

	void write_word( int regnum, r3000_word data ) {
		regs[regnum/2].write_word(regnum%2,data);
	}
	void write_single( int regnum, s_float data ) {
		regs[regnum/2].write_single(regnum%2,data);
	}
	void write_double( int regnum, d_float data ) {
		regs[regnum/2].write_double( data );
	}

	r3010_fgr& reg( int i ) { return regs[i/2]; }
//	r3010_fgr& operator[](int i) { return regs[i/2]; }
};

#endif /* R3010_FGR_H */
