/*
 * <<< r3010_fcr.cc >>>
 *
 * --- Copyright (C) 1996-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstring> // needed only for SGI C++ compiler
#include <iomanip> // needed only for SGI C++ compiler
#include <iostream>
#include "r3010_fcr.h"
#include "r3010.h"

extern const int fpa_version;

r3010_rel::r3010_rel( const r3010_base* body ) : r3010_fcr( body )
{
	d = 0x00000300 | (fpa_version & 0xff);
}

void
r3010_csr::reset()
{
	d = 0;
}

void
r3010_csr::write_word( r3000_word w )
{
	d = w;
}

void
r3010_csr::set_exc( int code )
{
	d &= ~(R3010_EXC_ALL << R3010_CSR_EXC_SHIFT);
	d |= ((code & R3010_EXC_ALL) << R3010_CSR_EXC_SHIFT) |
		((code & R3010_EXC_MASKABLE) << R3010_CSR_STICKY_SHIFT);
}

void
r3010_csr::set_cond( bool cond )
{
#ifdef DEBUG
	if( fpa->debug_level() & R3010_DEBUG_FPCOND )
		cout << "CSR::setcond(" << (cond ? "TRUE" : "FALSE" ) << ")" << endl;
#endif

	if( cond )
		d = d | (1<<R3010_CSR_COND_SHIFT);
	else
		d = d & ~(1<<R3010_CSR_COND_SHIFT);
}

bool
r3010_csr::exception()
{
	if( d & (R3010_EXC_E << R3010_CSR_EXC_SHIFT) )
		return true;

	register unsigned int sticky =
		(d >> R3010_CSR_STICKY_SHIFT) & R3010_EXC_MASKABLE;
	register unsigned int trap =
		(d >> R3010_CSR_TRAP_SHIFT) & R3010_EXC_MASKABLE;

	if( sticky & trap )
		return true;

	return false;
}

r3010_fcrbuf::r3010_fcrbuf( const r3010_base* body )
{
	fcr = new r3010_fcr*[NFCR];

	for( int i = 0; i < NFCR; i++ )
		fcr[i] = new r3010_fcr( body );
	_rel = new r3010_rel( body );
	_csr = new r3010_csr( body );
	fcr[R3010_REL] = _rel;
	fcr[R3010_CSR] = _csr;
}

void
r3010_fcrbuf::reset()
{
	for( int i = 0; i < NFCR; i++ )
		fcr[i]->reset();
}
