/* -*- C++ -*-
 *
 * <<< inst_op.h >>>
 *
 * --- Copyright (C) 1996-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef INST_OP_H
#define INST_OP_H 1

enum op_t {
	OP_COP1 = 021, OP_LWC1 = 061, OP_SWC1 = 071
};
#define OP_MASK			0xfc000000
#define OP_SHIFT		26

#define BASE_MASK		0x03e00000
#define BASE_SHIFT		21

#define OP25_MASK		0x02000000
#define OP25_SHIFT		25

enum sub_t {
	SUB_MF = 000, SUB_CF = 002, SUB_MT = 004, SUB_CT = 006,
	SUB_BC = 010
};
#define SUB_MASK		0x01e00000
#define SUB_SHIFT		21

enum br_t {
	BR_BC1F = 000, BR_BC1T = 001
};
#define BR_MASK			0x001f0000
#define BR_SHIFT		16

enum fmt_t {
	FMT_S, FMT_D, FMT_W = 4
};
#define FMT_MASK		0x01e00000
#define FMT_SHIFT		21

#define RT_MASK			0x001f0000
#define RT_SHIFT		16

#define RS_MASK			0x0000f800
#define RS_SHIFT		11

#define RD_MASK			0x000007c0
#define RD_SHIFT		6

enum func_t {
	FUNC_ADD, FUNC_SUB, FUNC_MUL, FUNC_DIV,
	FUNC_ABS = 005, FUNC_MOV, FUNC_NEG,

	FUNC_CVT_S = 040, FUNC_CVT_D, FUNC_CVT_W = 044,

	FUNC_C_F = 060, FUNC_C_UN, FUNC_C_EQ, FUNC_C_UEQ,
	FUNC_C_OLT, FUNC_C_ULT, FUNC_C_OLE, FUNC_C_ULE,
	FUNC_C_SF, FUNC_C_NGLE, FUNC_C_SEQ, FUNC_C_LT,
	FUNC_C_NGE, FUNC_C_LE, FUNC_C_NGT
};
#define FUNC_MASK		0x0000003f
#define FUNC_SHIFT		0

#define COND_LESS		(1<<2)
#define COND_EQUAL		(1<<1)
#define COND_UNORDERED	(1<<0)

#define OFS_MASK		0x0000ffff
#define OFS_SHIFT		0

#endif /* INST_OP_H */
