/*
 * <<< r3000_write_buffer_test.cc >>>
 *
 * --- Test program for r3000_write_buffer_unit class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstdlib>
#include <iostream>
#include "mapped_memory.h"
#include "memory_control_unit.h"
#include "r3000_typedef.h"
#include "r3000_bus_interface.h"
#include "r3000_cp0_register_file.h"
#include "r3000_memory_access_unit.h"
#include "r3000_write_buffer_unit.h"

typedef r3000_word word;
const size_t sizeof_word = sizeof_r3000_word;

static void write_test(r3000_memory_access_unit&, r3000_write_buffer_unit&,
					   memory_control_unit<word>&, bus_port<word>&,
					   mapped_memory<word, word>&);

int main(int argc, char** argv)
{
	const word top = (argc > 1) ? atoi(argv[1]) : 0,
			   size = (argc > 2) ? atoi(argv[2]) : 0x100;
	r3000_bus_interface bus_if;
	r3000_cp0_register_file cp0_rf;
	r3000_memory_access_unit ma(bus_if, cp0_rf);
	r3000_write_buffer_unit wbuf(ma);
	mapped_memory<word, word> mem_buf(top, size);
	memory_control_unit<word> mem;
	mem.set_read_wait(2);
	mem.set_write_wait(2);
	mem.port_ref().connect(bus_if);
	mem.connect_memory(mem_buf);

	write_test(ma, wbuf, mem, bus_if, mem_buf);
	cout << mem_buf << endl;
	return 0;
}

void write_test(r3000_memory_access_unit& ma, r3000_write_buffer_unit& wbuf,
				memory_control_unit<word>& mem, bus_port<word>& bus_if,
				mapped_memory<word, word>& mem_buf)
{
	const word top = mem_buf.top(), size = mem_buf.size();
	for (word adr = 0; adr < size; adr += sizeof_word) {
		wbuf.push(top + adr, adr);
		do {
			cerr << " in: " << bus_if << ", " << ma << ", " << wbuf << endl;
			wbuf.clock_in();
			ma.clock_in();
			mem.clock_in();
			cerr << "out: " << bus_if << ", " << ma << ", " << wbuf << endl;
			wbuf.clock_out();
			ma.clock_out();
			mem.clock_out();
		} while (wbuf.full());
	}
	do {
		cerr << " in: " << bus_if << ", " << ma << ", " << wbuf << endl;
		wbuf.clock_in();
		ma.clock_in();
		mem.clock_in();
		cerr << "out: " << bus_if << ", " << ma << ", " << wbuf << endl;
		wbuf.clock_out();
		ma.clock_out();
		mem.clock_out();
	} while (!wbuf.empty() || !wbuf.ready());
}
