/* -*- C++ -*-
 *
 * <<< r3000_write_buffer_unit.h >>>
 *
 * --- R3000 write buffer class 'r3000_write_buffer_unit'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3000_WRITE_BUFFER_UNIT_H
#define R3000_WRITE_BUFFER_UNIT_H 1

#include "r3000_write_buffer.h"
#include "r3000_memory_access_unit.h"

class ostream;

class r3000_write_buffer_unit
{
private:
	typedef r3000_write_buffer_unit thisclass;
	r3000_memory_access_unit& ma;
	r3000_write_buffer buf;
	enum state_type { READY, BUSY };
	state_type state;
public:
	typedef r3000_write_buffer::address_type address_type;
	typedef r3000_write_buffer::data_type data_type;
	typedef r3000_write_buffer::container_type container_type;
	typedef r3000_write_buffer::size_type size_type;
	r3000_write_buffer_unit(r3000_memory_access_unit&);
	r3000_write_buffer_unit(const thisclass&, r3000_memory_access_unit&);
	~r3000_write_buffer_unit();
	thisclass operator=(const thisclass&);
	inline void push(address_type, data_type);
	bool full(void) const { return buf.full(); }
	bool empty(void) const { return buf.empty(); }
	bool ready(void) const { return state == READY; }
	bool busy(void) const { return state == BUSY; }
	bool buffered(address_type a) const { return buf.buffered(a); }
	data_type read(address_type a) const { return buf.read(a); }
	void clock_in(void) {}
	inline void clock_out(void);
	void reset(void);
	void output(ostream&) const;
};

ostream& operator<<(ostream&, const r3000_write_buffer_unit&);

inline void r3000_write_buffer_unit::push(address_type a, data_type b)
{
	buf.push(a, b);
	if (ma.is_cacheable_data(a) && ma.is_data_cache_hit(a)) {
		ma.data_cache_write(a, b);
	}
}

inline void r3000_write_buffer_unit::clock_out(void)
{
	switch (state) {
	case READY:
		if (!buf.empty() && !ma.have_read_request()) {
			ma.send_data_write_request(buf.address(), buf.data());
			state = BUSY;
		}
		break;
	case BUSY:
		if (!ma.data_write_is_requested() &&
			(ma.data_write_is_trans() || ma.data_write_is_ready() ||
			 ma.data_write_is_trans_last())) {
			buf.pop();
			state = READY;
		}
		break;
	}
}

#endif /* R3000_WRITE_BUFFER_UNIT_H */
