/* -*- C++ -*-
 *
 * <<< bus_port.h >>>
 *
 * --- Bus port class 'bus_port'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef BUS_PORT_H
#define BUS_PORT_H 1

#include <iostream>
#include "bus_port_base.h"
#include "bus_packet.h"

template <class A, class D = A>
class bus_port : public bus_port_base<A, D>
{
private:
	typedef bus_port<A, D> thisclass;
	typedef bus_port_base<A, D> inherited;
	typedef bus_packet<A, D> packet_type;
public:
	typedef typename packet_type::address_type address_type;
	typedef typename packet_type::data_type data_type;
	bus_port(void);
	bus_port(const thisclass&);
	virtual ~bus_port();
	// send_single_{read,write}_{request,grant,ack,nack,data}()
	inline void send_single_read_request(const address_type&);
	inline void send_single_read_grant(void);
	inline void send_single_read_ack(void);
	inline void send_single_read_nack(void);
	inline void send_single_read_data(const data_type&);
	inline void send_single_write_request(const address_type&);
	inline void send_single_write_grant(void);
	inline void send_single_write_ack(void);
	inline void send_single_write_nack(void);
	inline void send_single_write_data(const data_type&);
	// send_multi_{read,write}_{request,grant,ack,nack,data}()
	inline void send_multi_read_request(const address_type&, size_t);
	inline void send_multi_read_grant(void);
	inline void send_multi_read_ack(void);
	inline void send_multi_read_nack(void);
	inline void send_multi_read_data(const data_type&, size_t, size_t);
	inline void send_multi_write_request(const address_type&, size_t);
	inline void send_multi_write_grant(void);
	inline void send_multi_write_ack(void);
	inline void send_multi_write_nack(void);
	inline void send_multi_write_data(const data_type&, size_t, size_t);
};

template <class A, class D>
inline void bus_port<A, D>::send_single_read_request(const address_type& a)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_single_read_request(a);
		put(p);
	} else {
		packet_reference().set_single_read_request(a);
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_single_read_grant(void)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_single_read_grant();
		put(p);
	} else {
		packet_reference().set_single_read_grant();
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_single_read_ack(void)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_single_read_ack();
		put(p);
	} else {
		packet_reference().set_single_read_ack();
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_single_read_nack(void)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_single_read_nack();
		put(p);
	} else {
		packet_reference().set_single_read_nack();
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_single_read_data(const data_type& a)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_single_read_data(a);
		put(p);
	} else {
		packet_reference().set_single_read_data(a);
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_single_write_request(const address_type& a)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_single_write_request(a);
		put(p);
	} else {
		packet_reference().set_single_write_request(a);
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_single_write_grant(void)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_single_write_grant();
		put(p);
	} else {
		packet_reference().set_single_write_grant();
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_single_write_ack(void)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_single_write_ack();
		put(p);
	} else {
		packet_reference().set_single_write_ack();
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_single_write_nack(void)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_single_write_nack();
		put(p);
	} else {
		packet_reference().set_single_write_nack();
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_single_write_data(const data_type& a)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_single_write_data(a);
		put(p);
	} else {
		packet_reference().set_single_write_data(a);
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_multi_read_request
	(const address_type& a, size_t b)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_multi_read_request(a, b);
		put(p);
	} else {
		packet_reference().set_multi_read_request(a, b);
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_multi_read_grant(void)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_multi_read_grant();
		put(p);
	} else {
		packet_reference().set_multi_read_grant();
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_multi_read_ack(void)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_multi_read_ack();
		put(p);
	} else {
		packet_reference().set_multi_read_ack();
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_multi_read_nack(void)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_multi_read_nack();
		put(p);
	} else {
		packet_reference().set_multi_read_nack();
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_multi_read_data
	(const data_type& a, size_t b, size_t c)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_multi_read_data(a, b, c);
		put(p);
	} else {
		packet_reference().set_multi_read_data(a, b, c);
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_multi_write_request
	(const address_type& a, size_t b)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_multi_write_request(a, b);
		put(p);
	} else {
		packet_reference().set_multi_write_request(a, b);
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_multi_write_grant(void)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_multi_write_grant();
		put(p);
	} else {
		packet_reference().set_multi_write_grant();
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_multi_write_ack(void)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_multi_write_ack();
		put(p);
	} else {
		packet_reference().set_multi_write_ack();
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_multi_write_nack(void)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_multi_write_nack();
		put(p);
	} else {
		packet_reference().set_multi_write_nack();
	}
}

template <class A, class D>
inline void bus_port<A, D>::send_multi_write_data
	(const data_type& a, size_t b, size_t c)
{
	if (!have_packet()) {
		packet_type* p = new packet_type;
		p->set_multi_write_data(a, b, c);
		put(p);
	} else {
		packet_reference().set_multi_write_data(a, b, c);
	}
}

template <class A, class D>
bus_port<A, D>::bus_port(void)
{}

template <class A, class D>
bus_port<A, D>::bus_port(const bus_port<A, D>& a)
	: inherited(a)
{}

template <class A, class D>
bus_port<A, D>::~bus_port()
{}

#endif /* BUS_PORT_H */
