/* -*- C++ -*-
 *
 * <<< packet_buffer.h >>>
 *
 * --- Packet buffer class 'packet_buffer'
 *     Copyright (C) 1997-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef PACKET_BUFFER_H
#define PACKET_BUFFER_H 1

#include "root_object.h"

#ifndef NULL
#define NULL 0
#endif

template <class T>
class packet_buffer : public root_object
{
public:
	typedef T packet_type;
private:
	typedef packet_buffer thisclass;
	typedef root_object inherited;
	packet_type* buf;
public:
	packet_buffer(void);
	packet_buffer(const thisclass&);
	packet_buffer& operator=(const thisclass&);
	virtual ~packet_buffer();
	bool have_packet(void) const { return buf != NULL; }
	inline void put(packet_type*);
	inline packet_type* get(void);
	inline const packet_type* look(void) const;
	inline packet_type* look(void);
	inline void clear(void);
};

template <class T>
inline void packet_buffer<T>::put(packet_buffer<T>::packet_type* a)
{
	if (have_packet()) delete buf;
	buf = a;
}

template <class T>
inline packet_buffer<T>::packet_type* packet_buffer<T>::get(void)
{
	packet_type* p = buf;
	buf = NULL;
	return p;
}

template <class T>
inline const packet_buffer<T>::packet_type* packet_buffer<T>::look(void)
	const
{
	return buf;
}

template <class T>
inline packet_buffer<T>::packet_type* packet_buffer<T>::look(void)
{
	return buf;
}

template <class T>
inline void packet_buffer<T>::clear(void)
{
	if (have_packet()) {
		delete buf;
		buf = NULL;
	}
}

template <class T>
packet_buffer<T>::packet_buffer(void)
	: buf(NULL)
{}

template <class T>
packet_buffer<T>::packet_buffer(const packet_buffer<T>&)
	: buf(NULL)
{}

template <class T>
packet_buffer<T>& packet_buffer<T>::operator=
	(const packet_buffer<T>& a)
{
	if (&a != this) clear();
	return *this;
}

template <class T>
packet_buffer<T>::~packet_buffer()
{
	clear();
}

#endif /* PACKET_BUFFER_H */
