/*
 * <<< mpni_io_funcs.c >>>
 *
 * --- Communication routines with isis::message_passing_network_interface
 *     'mpni_io_funcs'
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <stdio.h>
#include "mpni_io_funcs.h"
#include "multi_io_funcs.h"
#include "first_cache.h"
#include "io_protocol.h"

static int __mpni_init_flag = 0;
static volatile unsigned int* __mpni_address;
static size_t __mpni_max_packet_size;
static size_t __mpni_send_queue_size;
static size_t __mpni_recv_queue_size;

static void wait_for_ready(void);

static void wait_for_ready(void)
{
	while (__mpni_address[0] != (unsigned int)(MPNI_IO_READY)) {
		int i;
		for (i = 0; i < 10; i++);
	}
}

int __mpni_io_init(void)
{
	int t;
	if (__mpni_init_flag) return 1;
	if (!__multi_io_sysinfo_read_integer(
			"message_passing_network_interface_address", &t)) {
		return 0;
	}
	wait_for_ready();
	__mpni_address = (unsigned int*)(t);
	__mpni_address[0] = MPNI_IO_GET_PARAMETER;
	__mpni_max_packet_size = (size_t)(__mpni_address[1]);
	__mpni_send_queue_size = (size_t)(__mpni_address[2]);
	__mpni_recv_queue_size = (size_t)(__mpni_address[3]);
	__mpni_init_flag = 1;
	return 1;
}

size_t __mpni_io_get_max_packet_size(void)
{
	return __mpni_max_packet_size;
}

size_t __mpni_io_get_send_queue_size(void)
{
	return __mpni_send_queue_size;
}

size_t __mpni_io_get_receive_queue_size(void)
{
	return __mpni_recv_queue_size;
}

size_t __mpni_io_sense_send_queue(void)
{
	wait_for_ready();
	__mpni_address[0] = (unsigned int)(MPNI_IO_SENSE_SEND_QUEUE);
	return (size_t)(__mpni_address[1]);
}

size_t __mpni_io_sense_receive_queue(size_t* src, size_t* sz)
{
	size_t que_size;
	wait_for_ready();
	__mpni_address[0] = (unsigned int)(MPNI_IO_SENSE_RECEIVE_QUEUE);
	que_size = (size_t)(__mpni_address[3]);
	if (que_size > 0) {
		*src = (size_t)(__mpni_address[1]);
		*sz = (size_t)(__mpni_address[2]);
	}
	return que_size;
}

void __mpni_io_send(size_t dst, void* adr, size_t sz)
{
	wait_for_ready();
	__mpni_address[1] = (unsigned int)(dst);
	__mpni_address[2] = (unsigned int)(adr);
	__mpni_address[3] = (unsigned int)(sz);
	__mpni_address[0] = (unsigned int)(MPNI_IO_SEND);
}

void __mpni_io_receive(void* adr)
{
	wait_for_ready();
	__mpni_address[1] = (unsigned int)(adr);
	__mpni_address[0] = (unsigned int)(MPNI_IO_RECEIVE);
	wait_for_ready();
	__invalidate_first_data_cache();
	fflush(stdout); /* dummy wait... */
}

void __mpni_io_delete(void)
{
	wait_for_ready();
	__mpni_address[0] = (unsigned int)(MPNI_IO_DELETE);
	wait_for_ready();
}
