/*
 * <<< mpi_local.h >>>
 *
 * --- OSIRIS implementation of MPI subset 'mpi_local.h'
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef __MPI_LOCAL_H
#define __MPI_LOCAL_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <sys/types.h>
#include "mpi.h"

typedef struct {
	void* next;
	size_t source;
	size_t size;
} __MPI_buffer_header;

typedef struct {
	size_t total, index, size;
	int tag;
} __MPI_packet_header;

int __mpi_local_init(void);
void __mpi_local_finalize(void);
int __mpi_comm_rank(void);
int __mpi_comm_size(void);
__MPI_return_code __mpi_local_send(void*, int, MPI_Datatype, int, int);
__MPI_return_code __mpi_local_receive(void*, int, MPI_Datatype, int, int,
									  MPI_Status*);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __MPI_LOCAL_H */
