/*
 * <<< multi_io_funcs.h >>>
 *
 * --- Communication routines with isis::multi_io_unit 'multi_io_funcs'
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef MULTI_IO_FUNCS_H
#define MULTI_IO_FUNCS_H

#include <sys/types.h>

void __multi_io_halt(void);
int __multi_io_sysinfo_read_integer(const char*, int*);
int __multi_io_sysinfo_read_string(const char*, char*, size_t);
int __multi_io_sysinfo_write_integer(const char*, int);
int __multi_io_sysinfo_write_string(const char*, const char*);
int __multi_io_file_open(const char*, int);
int __multi_io_file_close(int);
int __multi_io_file_read(int, void*, size_t);
int __multi_io_file_write(int, const void*, size_t);
off_t __multi_io_file_lseek(int, off_t, int);
int __multi_io_commandline_read_argc(void);
void __multi_io_commandline_read_argv(int, size_t, size_t*, char*);
int __multi_io_commandline_write_status(int);

#endif /* MULTI_IO_FUNCS_H */
