/*
 * <<< mpni_io_funcs.h >>>
 *
 * --- Communication routines with isis::message_passing_network_interface
 *     'mpni_io_funcs'
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef MPNI_IO_FUNCS_H
#define MPNI_IO_FUNCS_H

#include <sys/types.h>

int __mpni_io_init(void);
size_t __mpni_io_get_max_packet_size(void);
size_t __mpni_io_get_send_queue_size(void);
size_t __mpni_io_get_receive_queue_size(void);
size_t __mpni_io_sense_send_queue(void);
size_t __mpni_io_sense_receive_queue(size_t*, size_t*);
void __mpni_io_send(size_t, void*, size_t);
void __mpni_io_receive(void*);
void __mpni_io_delete(void);

#endif /* MPNI_IO_FUNCS_H */
