/*
 * <<< mpi_test.c >>>
 *
 * --- Copyright (C) 2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <stdio.h>
#include "mpi.h"
#include "osiris.h"

void show(int* buf, int size)
{
	size_t i;
	printf("%d/%d [", get_puid(), get_punum());
	for (i = 0; i < size; i++) {
		printf("%02x", buf[i]);
		if ((i + 1) < size) printf(":");
	}
	printf("]\n");
	fflush(stdout);
}

int main(int argc, char** argv)
{
	const size_t N = 16;
	unsigned int buf[N];
	int punum, puid, mpi_rank, mpi_size, sendto, recvfrom;

	/* get punum and puid */
	punum = get_punum();
	puid = get_puid();

	/* init */
	printf("%d/%d MPI_Init:\n", puid, punum); fflush(stdout);
	MPI_Init(&argc, &argv);
	printf("%d/%d ... done.\n", puid, punum); fflush(stdout);

	/* get rank and size */
	printf("%d/%d MPI_Comm_{rank,size}:\n", puid, punum); fflush(stdout);
	MPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);
	MPI_Comm_size(MPI_COMM_WORLD, &mpi_size);
	printf("%d/%d ... done. rank=%d, size=%d.\n",
		   puid, punum, mpi_rank, mpi_size);
	fflush(stdout);

	/* set addresses: sendto, recvfrom */
	sendto = (mpi_rank + 1) % mpi_size;
	recvfrom = (mpi_rank + mpi_size - 1) % mpi_size;
	printf("%d/%d sendto:%d, recvfrom:%d.\n",
		   puid, punum, sendto, recvfrom);
	fflush(stdout);

	/* setup buffer contents */
	{
		size_t i;
		for (i = 0; i < N; i++) buf[i] = (unsigned int)(mpi_rank * 0x10 + i);
	}
	printf("%d/%d original data is:\n", puid, punum);
	show(buf, N);

	/* MPI_Isend */
	printf("%d/%d MPI_Isend:\n", puid, punum);
	MPI_Isend(buf, N, MPI_UNSIGNED, sendto, 0, MPI_COMM_WORLD, NULL);
	printf("%d/%d ... done.\n", puid, punum);

	/* finalize */
	printf("%d/%d MPI_Finalize:\n", puid, punum); fflush(stdout);
	MPI_Finalize();
	printf("%d/%d ... done.\n", puid, punum); fflush(stdout);

	return 0;
}
