/*
 * <<< startup.c >>>
 *
 * --- Startup and shutdown program for osiris 'startup.c'
 *     Copyright (C) 1996-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <stdlib.h>
#include "osiris_address.h"
#include "comm_io_funcs.h"
#include "multi_io_funcs.h"

int main(int, char**);

void __startup(void) /* arguments(argc, argv, return_address) are ignored */
{
	int argc;
	static char* argv[64];
	static char args[1024];
	__comm_io_init((void*)__osiris_multi_io_area);
	{
		char* p = args;
		int remainder = sizeof(args), i;
		argc = __multi_io_commandline_read_argc();
		if (argc >= sizeof(argv) / sizeof(argv[0])) {
			argc = sizeof(argv) / sizeof(argv[0]) - 1;
		}
		for (i = 0; i < argc; i++) {
			size_t len;
			argv[i] = p;
			__multi_io_commandline_read_argv(i, remainder, &len, p);
			if (len == 0) {
				argc = i;
				break;
			}
			p += (len + 1);
		}
		argv[argc] = NULL;
	}
	exit(main(argc, argv));
	/* not reached */
}

void _exit(int status)
{
	volatile int tmp = 0;
	__multi_io_commandline_write_status(status);
	__multi_io_halt();
	while (1) tmp; /* flush write buffer */
	/* not reached */
}
