/*
 * <<< osiris_address.c >>>
 *
 * --- Default address variable for osiris 'osiris_address.c'
 *     Copyright (C) 1997-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "osiris_address.h"

#define DEFAULT_STACK_SIZE				0x4000
#define DEFAULT_MULTI_IO_AREA			0xbfd00000

static int default_stack[DEFAULT_STACK_SIZE / sizeof(int)];

int *__init_stack_pointer =
	default_stack + sizeof(default_stack) / sizeof(default_stack[0]) - 6;
	/* 6 * sizeof(int) is minimal stack size */
unsigned __osiris_multi_io_area = DEFAULT_MULTI_IO_AREA;
