/*
 * <<< io_protocol.h >>>
 *
 * --- I/O protocol definition between isis and osiris 'io_protocol.h'
 *     Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef IO_PROTOCOL_H
#define IO_PROTOCOL_H 1

/* comm_io_unit protocol */
#define COMM_IO_READY			0
#define COMM_IO_SEND_REQUEST	1
#define COMM_IO_RECEIVE_REQUEST	2
#define COMM_IO_ACK				3
#define COMM_IO_NACK			4

/* sysinfo_io_unit, file_io_unit protocol and others */
#define IO_COMMON_ACK						0x00
#define IO_COMMON_NACK						0x01
#define IO_HALT_REQUEST						0x10
#define IO_SYSINFO_READ_INTEGER_REQUEST		0x20
#define IO_SYSINFO_READ_STRING_REQUEST		0x21
#define IO_SYSINFO_WRITE_INTEGER_REQUEST	0x22
#define IO_SYSINFO_WRITE_STRING_REQUEST		0x23
#define IO_FILE_OPEN_REQUEST				0x30
#define IO_FILE_CLOSE_REQUEST				0x31
#define IO_FILE_READ_REQUEST				0x32
#define IO_FILE_WRITE_REQUEST				0x33
#define IO_FILE_LSEEK_REQUEST				0x34
#define IO_COMMANDLINE_READ_ARGC_REQUEST	0x40
#define IO_COMMANDLINE_READ_ARGV_REQUEST	0x41
#define IO_COMMANDLINE_WRITE_STATUS_REQUEST	0x42

/* file_io_unit protocol */
#define IO_FILE_OPEN_RDONLY		0x01
#define IO_FILE_OPEN_WRONLY		0x02
#define IO_FILE_OPEN_RDWR		0x04
#define IO_FILE_OPEN_APPEND		0x08
/* #define IO_FILE_OPEN_CREAT	0x10 (obsolete) */
#define IO_FILE_OPEN_TRUNC		0x20
/* #define IO_FILE_OPEN_EXCL	0x40 (obsolete) */

#define IO_FILE_SEEK_SET		0
#define IO_FILE_SEEK_CUR		1
#define IO_FILE_SEEK_END		2

/* mp_network_interface protocol: request type */
#define MPNI_IO_SENSE		 0
#define MPNI_IO_SEND		 1
#define MPNI_IO_PSEND		 2
#define MPNI_IO_RAWSEND		 3
#define MPNI_IO_PRAWSEND	 4
#define MPNI_IO_RECV		 5
#define MPNI_IO_PRECV		 6
#define MPNI_IO_RAWRECV		 7
#define MPNI_IO_PRAWRECV	 8
#define MPNI_IO_LATEBIND	 9
#define MPNI_IO_LATECANCEL	10

/* mp_network_interface protocol: hardware register offset */
#define MPNI_IO_OFFSET_REQUEST_TYPE				0x00
#define MPNI_IO_OFFSET_REQUEST_ID				0x01
#define MPNI_IO_OFFSET_PARTNER_ADDRESS			0x02
#define MPNI_IO_OFFSET_HEADER_ADDRESS			0x03
#define MPNI_IO_OFFSET_HEADER_SIZE				0x04
#define MPNI_IO_OFFSET_DATA_ADDRESS				0x05
#define MPNI_IO_OFFSET_DATA_SIZE				0x06
#define MPNI_IO_OFFSET_FLAGS					0x07
#define MPNI_IO_OFFSET_MAX_DATA_SIZE			0x10
#define MPNI_IO_OFFSET_SENDREQBUF_SIZE			0x11
#define MPNI_IO_OFFSET_RECVREQBUF_SIZE			0x12
#define MPNI_IO_OFFSET_RECVPOOL_SIZE			0x13
#define MPNI_IO_OFFSET_SENDFLAGS_OFFSET			0x14
#define MPNI_IO_OFFSET_RECVFLAGS_OFFSET			0x15
#define MPNI_IO_OFFSET_PENDING_SENDREQ_COUNT	0x18
#define MPNI_IO_OFFSET_PENDING_RECVREQ_COUNT	0x19
#define MPNI_IO_OFFSET_PENDING_RECVPOOL_COUNT	0x1a

/* mp_network_interface protocol: masks for flags */
#define MPNI_IO_FLAGS_MASK_ANYSRC		0x1
#define MPNI_IO_FLAGS_MASK_ANYSIZE		0x2
#define MPNI_IO_FLAGS_MASK_LATEBIND		0x4
#define MPNI_IO_FLAGS_MASK_CANCEL		0x8

#endif /* IO_PROTOCOL_H */
