/*
 * <<< mpni_io_funcs_test.c >>>
 *
 * --- Communication routines with isis::mp_network_interface
 *     'mpni_io_funcs'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <stdio.h>
#include "first_cache.h"
#include "mpni_io_funcs.h"

void __mpni_io_show_fixed_parameters();
void __mpni_io_show_variable_parameters();

void show(unsigned int* hdr, int hsz, unsigned int* dat, int dsz)
{
	int i;
	printf("(");
	for (i = 0; i < hsz; i++) {
		if (i > 0) printf(":");
		printf("%02x", hdr[i]);
	}
	for (i = 0; i < dsz; i++) {
		printf(i == 0 ? "," : ":");
		printf("%02x", dat[i]);
	}
	printf(")");
}

int main(void)
{
	const size_t H = 4, D = 8;
	unsigned int shdr[H], sdat[D], dhdr[H], ddat[D];
	size_t i;
	if (!__mpni_io_init()) {
		fprintf(stderr, "cannot initialize NI.\n");
		exit(1);
	}
	__mpni_io_show_fixed_parameters();
	__mpni_io_show_variable_parameters();
	/*
	for (i = 0; i < H; i++) shdr[i] = (unsigned int)(i + 0x40);
	for (i = 0; i < D; i++) sdat[i] = (unsigned int)(i);
	for (i = 0; i < H; i++) dhdr[i] = 0;
	for (i = 0; i < D; i++) ddat[i] = 0;
	printf("src:"); show(shdr, H, sdat, D); printf("\n");
	printf("dst:"); show(dhdr, H, ddat, D); printf("\n");
	__mpni_io_send(0, shdr, H, sdat, D, &i);
	__mpni_io_precv(0, dhdr, H, NULL, D, 0, &i);
	__invalidate_first_data_cache_partially(&dhdr[0], &dhdr[H]);
	while (__mpni_io_recv_poll(i));
	__mpni_io_latebind(i, ddat);
	__invalidate_first_data_cache_partially(&ddat[0], &ddat[D]);
	while (__mpni_io_recv_poll(i));
	printf("src:"); show(shdr, H, sdat, D); printf("\n");
	printf("dst:"); show(dhdr, H, ddat, D); printf("\n");
	*/
	return 0;
}
