/*
 *	<<< first_cache.h >>>
 *
 * --- cache management functions for MIPS CPU 'first_cache.h'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef __FIRST_CACHE_H
#define __FIRST_CACHE_H 1

unsigned int __get_first_instruction_cache_size(void);
unsigned int __get_first_data_cache_size(void);
void __invalidate_first_instruction_cache_inner(void*, void*);
void __invalidate_first_data_cache_inner(void*, void*);

extern int __get_first_instruction_cache_size_flag;
extern int __get_first_data_cache_size_flag;
extern unsigned int __first_instruction_cache_size;
extern unsigned int __first_data_cache_size;

#define __invalidate_first_instruction_cache(x) \
{ \
	if (!__get_first_instruction_cache_size_flag) { \
		__get_first_instruction_cache_size_flag = 1; \
		__first_instruction_cache_size = __get_first_instruction_cache_size(); \
	} \
	__invalidate_first_instruction_cache_inner( \
		(void*)0, (void*)__first_instruction_cache_size); \
}

#define __invalidate_first_data_cache(x) \
{ \
	if (!__get_first_data_cache_size_flag) { \
		__get_first_data_cache_size_flag = 1; \
		__first_data_cache_size = __get_first_data_cache_size(); \
	} \
	__invalidate_first_data_cache_inner( \
		(void*)0, (void*)__first_data_cache_size); \
}

#define __invalidate_first_data_cache_partially(a, b) \
{ \
	if (!__get_first_data_cache_size_flag) { \
		__get_first_data_cache_size_flag = 1; \
		__first_data_cache_size = __get_first_data_cache_size(); \
	} \
	if (((unsigned int)(b) - (unsigned int)(a)) >= __first_data_cache_size) { \
		__invalidate_first_data_cache_inner( \
			(void*)0, (void*)__first_data_cache_size); \
	} else { \
		unsigned int a_ = ((unsigned int)(a) & (~(0x40 - 1))); \
		unsigned int b_ = (((unsigned int)(b) + 0x40) & (~(0x40 - 1))); \
		__invalidate_first_data_cache_inner((void*)a_, (void*)b_); \
	} \
}

#endif /* __FIRST_CACHE_H */
