/*
 *	<<< first_cache.c >>>
 *
 * --- cache management functions for MIPS CPU 'first_cache.c'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "first_cache.h"

int __get_first_instruction_cache_size_flag = 0;
int __get_first_data_cache_size_flag = 0;
unsigned int __first_instruction_cache_size;
unsigned int __first_data_cache_size;

#if 0

/* these functions are defined as macros in first_cache.h */

void __invalidate_first_instruction_cache(void)
{
	if (!__get_first_instruction_cache_size_flag) {
		__get_first_instruction_cache_size_flag = 1;
		__first_instruction_cache_size = __get_first_instruction_cache_size();
	}
	__invalidate_first_instruction_cache_inner(
		(void*)0, (void*)__first_instruction_cache_size);
}

void __invalidate_first_data_cache(void)
{
	if (!__get_first_data_cache_size_flag) {
		__get_first_data_cache_size_flag = 1;
		__first_data_cache_size = __get_first_data_cache_size();
	}
	__invalidate_first_data_cache_inner(
		(void*)0, (void*)__first_data_cache_size);
}

void __invalidate_first_data_cache_partially(void* a, void* b)
{
	if (!__get_first_data_cache_size_flag) {
		__get_first_data_cache_size_flag = 1;
		__first_data_cache_size = __get_first_data_cache_size();
	}
	if (((unsigned int)b - (unsigned int)a) >= __first_data_cache_size) {
		__invalidate_first_data_cache_inner(
			(void*)0, (void*)__first_data_cache_size);
	} else {
		unsigned int a_ = ((unsigned int)(a) & (~(0x40 - 1)));
		unsigned int b_ = (((unsigned int)(b) + 0x40) & (~(0x40 - 1)));
		__invalidate_first_data_cache_inner((void*)a_, (void*)b_);
	}
}

#endif
