/*
 * <<< sbrk.c >>>
 *
 * --- Systemcall handler for isis 'sbrk.c'
 *     Copyright (C) 1998-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <unistd.h>

#define HEAP_SIZE	0x10000000

#ifndef NULL
#define NULL 0
#endif

void *sbrk(size_t incr)
{
	static char buf[HEAP_SIZE];
	static char *ptr = buf;
	if (ptr + incr < buf + sizeof(buf) && ptr + incr >= buf) {
		char *val = ptr;
		ptr += incr;
		return val;
	} else {
		return (char*)(-1);
	}
}
