dnl Checks for package, version, library interface version.
dnl CF_CHECK_VERSION(VERSION-FILE-NAME [, LT-VERSION-FILE-NAME])
AC_DEFUN(CF_CHECK_VERSION, [
	if test -f "${srcdir}/$1"; then :; else
		AC_MSG_ERROR(Missing version file.)
	fi
	AC_MSG_CHECKING(package name)
	PACKAGE=`sed -n '1s/^\([[a-zA-Z0-9_.]][[a-zA-Z0-9_.]]*\) *version.*$/\1/p' ${srcdir}/$1`
	if test -z "$PACKAGE"; then
		AC_MSG_ERROR(Bad version file.)
	fi
	AC_MSG_RESULT($PACKAGE)
	AC_MSG_CHECKING(version number)
	VERSION=`sed -n '1s/^.*version *\([[0-9.]][[0-9.]]*\).*$/\1/p' ${srcdir}/$1`
	if test -z "$VERSION"; then
		AC_MSG_ERROR(Bad version file.)
	fi
	AC_MSG_RESULT($VERSION)
	AC_MSG_CHECKING(revision string)
	REVISION="`sed -n '1s/^.*version.*(\(.*\))/\1/p' ${srcdir}/$1`"
	test -z "$REVISION" && REVISION=release
	AC_MSG_RESULT($REVISION)
	MAJOR_VERSION=`echo $VERSION | sed -n 's/^\([[0-9]][[0-9]]*\).*/\1/p'`
	MINOR_VERSION=`echo $VERSION | sed -n 's/^[[0-9]][[0-9]]*\.\([[0-9]][[0-9]]*\).*/\1/p'`
	MICRO_VERSION=`echo $VERSION | sed -n 's/^[[0-9]][[0-9]]*\.[[0-9]][[0-9]]*\.\([[0-9]][[0-9]]*\).*/\1/p'`
	MAJOR_VERSION=`expr $MAJOR_VERSION + 0`
	MINOR_VERSION=`expr $MINOR_VERSION + 0`
	MICRO_VERSION=`expr $MICRO_VERSION + 0`
	AC_SUBST(PACKAGE)
	AC_SUBST(VERSION)
	AC_SUBST(REVISION)
	AC_SUBST(MAJOR_VERSION)
	AC_SUBST(MINOR_VERSION)
	AC_SUBST(MICRO_VERSION)
	ifelse("$2","",,[
		if test -f "${srcdir}/$2"; then :; else
			AC_MSG_ERROR(Missing lt-version file.)
		fi
		AC_MSG_CHECKING(library version)
		interface_age=`sed -n '1s/^\([[0-9]][[0-9]]*\)\..*$/\1/p' ${srcdir}/$2`
		binary_age=`sed -n '1s/^.*\.\([[0-9]][[0-9]]*\)$/\1/p' ${srcdir}/$2`
		LT_RELEASE=$MAJOR_VERSION.$MINOR_VERSION
		LT_CURRENT=`expr $MICRO_VERSION - $interface_age`
		LT_REVISION=$interface_age
		LT_AGE=`expr $binary_age - $interface_age`
		AC_MSG_RESULT([release $LT_RELEASE, version ${LT_CURRENT}.${LT_REVISION}.${LT_AGE}])
		AC_SUBST(LT_RELEASE)
		AC_SUBST(LT_CURRENT)
		AC_SUBST(LT_REVISION)
		AC_SUBST(LT_AGE)
	])
])

dnl Checks for option for specified command.
dnl CF_CHECK_OPTION(PROGRAM-VARIABLE, FLAG-VARIABLE, OPTION)
AC_DEFUN(CF_CHECK_OPTION, [
	changequote(<<,>>)dnl
	define(<<cacheval>>, translit(cf_cv_prog_$1_$3, +-, P_))dnl
	changequote([,])dnl
	AC_CACHE_CHECK(whether [$]$1 accepts $3, cacheval, [
		echo 'int main(void) { return 0; }' > conftest.$ac_ext
		if test -z "`[$]$1 [$]$2 $3 -c conftest.$ac_ext 2>&1`"; then
			cacheval=yes
		else
			cacheval=no
		fi
		rm -fr conftest*
	])
	if test x$cacheval = xyes; then
		if test ! x"`echo [$]$2 | sed -n 's,.*$3.*,x,p'`" = xx; then
			$2="[$]$2 $3"
		fi
	fi
])
