set search_path [concat "/home/cad/lib/osu_stdcells/lib/tsmc018/lib/" $search_path]
set LIB_MAX_FILE {osu018_stdcells.db  }

set link_library $LIB_MAX_FILE
set target_library $LIB_MAX_FILE

read_verilog alu.v
read_verilog rfile.v
read_verilog pocop.v
current_design "pocop"
create_clock -period 3 clk 
set_input_delay 2.0 -clock clk [find port "idatain*"]
set_input_delay 2.0 -clock clk [find port "ddatain*"]
set_output_delay 0.2 -clock clk [all_outputs]

set_max_fanout 12 [current_design]

set_max_area 0

compile -map_effort medium -area_effort medium

report_timing -max_paths 10
report_power -hier 

report_area

write -hier -format verilog -output poco.vnet

quit
