`include "def2.h"
module poco(
input clk, rst_n,
input [`DATA_W-1:0] datain,
output [`DATA_W-1:0] addr,
output [`DATA_W-1:0] dataout,
output we);

reg [`DATA_W-1:0] pc;
reg [`DATA_W-1:0] ir;
reg [`STAT_W-1:0] stat;
wire [`DATA_W-1:0] rf_a, rf_b, rf_c;
wire [`DATA_W-1:0] alu_a, alu_b, alu_y;
wire [`OPCODE_W-1:0] opcode;
wire [`OPCODE_W-1:0] func;
wire [`REG_W-1:0] rs, rd, cadr;
wire [`SEL_W-1:0] com;
wire [`IMM_W-1:0] imm;
wire [`JIMM_W-1:0] jimm;
wire pcset, rwe;
wire st_op, bez_op, bnz_op, bmi_op, bpl_op, addi_op, ld_op, alu_op;
wire ldi_op, ldiu_op, ldhi_op, addiu_op, jmp_op, jal_op, jr_op, b_op, j_op;

assign dataout = rf_a;
assign addr = stat[`IF] ? pc: rf_b;

assign {opcode, rd, rs, func} = ir;
assign imm = ir[`IMM_W-1:0];
assign jimm = ir[`JIMM_W-1:0];

// Decorder
assign st_op = stat[`EX] & (opcode == `OP_REG) & (func == `F_ST);
assign ld_op = stat[`EX] & (opcode == `OP_REG) & (func == `F_LD);
assign jr_op = stat[`EX] & (opcode == `OP_REG) & (func == `F_JR);
assign alu_op = stat[`EX] & (opcode == `OP_REG) & (func[4:3] == 2'b00);
assign ldi_op = stat[`EX] & (opcode == `OP_LDI);
assign ldiu_op = stat[`EX] & (opcode == `OP_LDIU);
assign addi_op = stat[`EX] & (opcode == `OP_ADDI);
assign addiu_op = stat[`EX] & (opcode == `OP_ADDIU);
assign ldhi_op = stat[`EX] & (opcode == `OP_LDHI);
assign bez_op = stat[`EX] & (opcode == `OP_BEZ);
assign bnz_op = stat[`EX] & (opcode == `OP_BNZ);
assign bpl_op = stat[`EX] & (opcode == `OP_BPL);
assign bmi_op = stat[`EX] & (opcode == `OP_BMI);
assign jmp_op = stat[`EX] & (opcode == `OP_JMP);
assign jal_op = stat[`EX] & (opcode == `OP_JAL);

assign we = st_op;
assign b_op = bez_op | bnz_op | bpl_op | bmi_op;
assign j_op = jmp_op | jal_op ;

assign alu_a = (stat[`IF] | b_op | j_op ) ? pc : rf_a;

assign alu_b = stat[`IF] ? 16'b1: 
		(addi_op | ldi_op | b_op) ? {{8{imm[7]}},imm} :
		(addiu_op | ldiu_op ) ? {8'b0,imm} :
		(j_op) ? {{5{jimm[10]}},jimm} :
		(ldhi_op) ? {imm, 8'b0} : rf_b;

assign com = (stat[`IF] | addi_op | addiu_op | b_op | j_op ) ? `ALU_ADD: 
		(ldi_op | ldiu_op | ldhi_op) ? `ALU_THB: 
                (jr_op) ? `ALU_THA :  func[`SEL_W-1:0];

assign rf_c = ld_op  ? datain : jal_op ? pc : alu_y;
assign rwe = ld_op  | alu_op | ldi_op | ldiu_op | addi_op | addiu_op | ldhi_op
                | jal_op ;
assign cadr = jal_op ? 3'b111 : rd;
alu alu_1(.a(alu_a), .b(alu_b), .s(com), .y(alu_y));

rfile rfile_1(.clk(clk), .a(rf_a), .aadr(rd), .b(rf_b), .badr(rs), 
	.c(rf_c), .cadr(cadr), .we(rwe));

assign pcset = stat[`IF] |   (bez_op & rf_a == 16'b0 ) | (bnz_op & rf_a != 16'b0) |
              (bmi_op & rf_a[15] == 1 ) | (bpl_op & rf_a[15] == 0) | jal_op | j_op | jr_op ;

always @(posedge clk or negedge rst_n) 
begin 
   if(!rst_n) pc <= 0;
   else if(pcset) pc <= alu_y;
end

always @(posedge clk or negedge rst_n) 
begin 
   if(!rst_n) ir <= 0;
   else if(stat[`IF])
     ir <= datain;
end
always @(posedge clk or negedge rst_n) 
begin
   if(!rst_n) stat <= `STAT_IF;
   else
    case (stat)
      `STAT_IF: stat <= `STAT_EX;
      `STAT_EX: stat <= `STAT_IF;
    endcase
end

endmodule
