/* test bench */
`timescale 1ns/1ps
`include "def.h"
module test_mipse;
parameter STEP = 10;
integer FP;
integer i;

   reg clk, rst_n;
   reg[31:0] count;
   reg[31:0] stall;
   reg[31:0] instr1ok;
   wire [`DATA_W-1:0] ddataout0, ddatain0 ;
   wire [`DATA_W-1:0] ddataout1, ddatain1 ;
   wire [`DATA_W-1:0] iaddr;
   wire [`DATA_W-1:0] daddr0, daddr1;
   wire [`DATA_W-1:0] idata0, idata1;
   wire we0, we1;
  
   always #(STEP/2) begin
            clk <= ~clk;
   end

   mipse mipse_1(.clk(clk), .rst_n(rst_n), .instre(idata0), .instro(idata1),
               .readdata0(ddatain0), .readdata1(ddatain1), .pc(iaddr), .aluout0(daddr0), .aluout1(daddr1),
               .writedata0(ddataout0), .writedata1(ddataout1), .memwrite0(we0), .memwrite1(we1) );
  imem  imem_1(.a(iaddr[17:2]), .rde(idata0), .rdo(idata1) );
  dmem  dmem_1(.clk(clk), .a0(daddr0[17:2]), .a1(daddr1[17:2]), .rd0(ddatain0), .rd1(ddatain1),
  					.wd0(ddataout0), .wd1(ddataout1), .we0(we0), .we1(we1) );

   initial begin
      $dumpfile("mipse.vcd");
      $dumpvars(0,test_mipse);
	  FP= $fopen("result.dat");
      clk <= `DISABLE;
      rst_n <= `ENABLE_N;
	  count <= 0;
	  stall <= 0;
	  instr1ok <= 0;
   #(STEP*1/4)
   #STEP
      rst_n <= `DISABLE_N;
   #(STEP*1000)
   $finish;
   end

   always @(negedge clk) begin
      $display("pc:%h inst0:%h inst1:%h stall:%b 2slot:%b", mipse_1.pc, mipse_1.instre, mipse_1.instro, mipse_1.stall, mipse_1.instr1ok);
      $display("reg:%h %h %h %h %h %h %h", 
	mipse_1.rfile_1.rf[1], mipse_1.rfile_1.rf[2],
	mipse_1.rfile_1.rf[3], mipse_1.rfile_1.rf[4], mipse_1.rfile_1.rf[5],
	mipse_1.rfile_1.rf[6], mipse_1.rfile_1.rf[7]); 
      $display("mem:%h %h %h %h", 
	dmem_1.mem[0], dmem_1.mem[1],
	dmem_1.mem[2], dmem_1.mem[3]);
	count <= count+1;
	if(mipse_1.stall) stall <= stall+1;
	if(mipse_1.instr1ok) instr1ok <= instr1ok+1;
    if( (daddr0 == 32'h7fff) & we0 | (daddr1 == 32'h7fff) & we1) begin
        $display("%h count:%d stall:%d 2slot:%d",we0? ddataout0:ddataout1,count,stall,instr1ok);
		for(i=0; i<200; i=i+1)
		            $fdisplay(FP,"%h", dmem_1.mem[i]);
       $finish;
	end
   end 
endmodule
