/* test bench */
`timescale 1ns/1ps
`include "def.h"
module test_mipse;
parameter STEP = 10;
   reg clk, rst_n;
   wire [`DATA_W-1:0] ddataout2, ddatain2 ;
   wire [`DATA_W-1:0] ddataout3, ddatain3 ;
   wire [`DATA_W-1:0] iaddr;
   wire [`DATA_W-1:0] daddr2, daddr3;
   wire [`DATA_W*4-1:0] idata;
   wire we2, we3;
   reg [31:0] count;
   reg [31:0] instc;
  
   always #(STEP/2) begin
            clk <= ~clk;
   end

   mipse mipse_1(.clk(clk), .rst_n(rst_n), .instr(idata),
               .readdata2(ddatain2), .readdata3(ddatain3), 
			   .pc(iaddr), .aluout2(daddr2), .aluout3(daddr3),
               .writedata2(ddataout2), .writedata3(ddataout3), 
			   .memwrite2(we2), .memwrite3(we3) );
  imem  imem_1(.a(iaddr[15:2]), .rd(idata) );
  dmem  dmem_1(.clk(clk), .a0(daddr2[17:2]), .a1(daddr3[17:2]), .rd0(ddatain2), .rd1(ddatain3),
  					.wd0(ddataout2), .wd1(ddataout3), .we0(we2), .we1(we3) );

   initial begin
      $dumpfile("mipse.vcd");
      $dumpvars(0,test_mipse);
      clk <= `DISABLE;
      rst_n <= `ENABLE_N;
	  count <= 0;
	  instc <= 0;
   #(STEP*1/4)
   #STEP
      rst_n <= `DISABLE_N;
   #(STEP*1000)
   $finish;
   end

   always @(negedge clk) begin
      $display("pc:%h idatain:%h instc:%d", mipse_1.pc, mipse_1.instr, instc);
      $display("reg:%h %h %h %h %h %h %h", 
	mipse_1.rfile_1.rf[1], mipse_1.rfile_1.rf[2],
	mipse_1.rfile_1.rf[3], mipse_1.rfile_1.rf[4], mipse_1.rfile_1.rf[5],
	mipse_1.rfile_1.rf[6], mipse_1.rfile_1.rf[7]); 
      $display("mem:%h %h %h %h", 
	dmem_1.mem[0], dmem_1.mem[1],
	dmem_1.mem[2], dmem_1.mem[3]);
	count <= count+1;
	instc <= instc + ( (idata === 128'bx) ? 0 : 
	(|idata[`DATA_W-1:0]) + (|idata[`DATA_W*2-1:`DATA_W])+
			(|idata[`DATA_W*3-1:`DATA_W*2]) + (|idata[`DATA_W*4-1:`DATA_W*3]) ) ;
	if( (daddr2 == 32'h7fff) & we2 | (daddr3 == 32'h7fff) & we3) begin
	        $display("%h count:%d instc:%d",we2?ddataout2:ddataout3,count,instc);
			$finish;
   end
   end 
endmodule
