`include "def.h"
module rfile (
 input clk,
 input [`REG_W-1:0] a1, a2, a3, a4, a5, a6,
 output [`DATA_W-1:0] rd1, rd2, rd4, rd5,
 input [`DATA_W-1:0] wd3, wd6,
 input we3, we6);

	reg [`DATA_W-1:0] rf[0:`REG-1];

	assign rd1 = |a1 == 0 ? 0 : rf[a1];
	assign rd2 = |a2 == 0 ? 0 : rf[a2];
	assign rd4 = |a4 == 0 ? 0 : rf[a4];
	assign rd5 = |a5 == 0 ? 0 : rf[a5];

	always @(negedge clk) 
		if(we3 & !we6) rf[a3] <= wd3;
		else if (!we3 & we6) rf[a6] <= wd6;
		else if (we3 & we6) begin 
				if(a3==a6) rf[a3] <= wd3; 
				else begin rf[a3] <= wd3; rf[a6] <= wd6; end
		end

endmodule
