`include "def.h"
module mipse(
input clk, rst_n,
input [`DATA_W-1:0] instre,instro,
input [`DATA_W-1:0] readdata0, readdata1,
output reg [`DATA_W-1:0] pc,
output [`DATA_W-1:0] aluout0, aluout1,
output [`DATA_W-1:0] writedata0, writedata1,
output memwrite0, memwrite1);

wire [`REG_W-1:0] rsI0, rdI0, rtI0;
wire [`OPCODE_W-1:0] opcodeI0;
wire [`SHAMT_W-1:0] shamtI0;
wire [`OPCODE_W-1:0] funcI0;
wire [`REG_W-1:0] rsI1, rdI1, rtI1;
wire [`OPCODE_W-1:0] opcodeI1;
wire [`SHAMT_W-1:0] shamtI1;
wire [`OPCODE_W-1:0] funcI1;
wire sw_opI0, lw_opI0, alu_opI0, addi_opI0, ori_opI0;
wire lui_opI0, beq_opI0, bne_opI0, branchI0;
wire sw_opI1, lw_opI1, alu_opI1, addi_opI1, ori_opI1;
wire lui_opI1, beq_opI1, bne_opI1, branchI1;
reg [`DATA_W-1:0] pcplus4D ;
wire [`DATA_W-1:0] pcplus4F, pcplus8F ;
wire [`DATA_W-1:0] pcbranchD ;
reg [`DATA_W-1:0] instrD0, instrD1 ;
wire [`DATA_W-1:0] instrD0s, instrD1s ;
wire stall;
wire btakenD;
wire branchD0, branchD1;
wire instr1ok;
wire rtsnd0, rsrec1, rtrec1;
reg slot;

/*  Instruction Fetch Stage */
assign sw_opI0 = (opcodeI0 == `OP_SW);
assign lw_opI0 = (opcodeI0 == `OP_LW);
assign alu_opI0 = (opcodeI0 == `OP_REG) & (
	(funcI0[5:3] == 3'b100)|(funcI0 == `FUNC_MULT) );
assign addi_opI0 = (opcodeI0 == `OP_ADDI);
assign ori_opI0 = (opcodeI0 == `OP_ORI);
assign lui_opI0 = (opcodeI0 == `OP_LUI);
assign beq_opI0 = (opcodeI0 == `OP_BEQ);
assign bne_opI0 = (opcodeI0 == `OP_BNE);
assign branchI0 = beq_opI0 | bne_opI0;

assign sw_opI1 = (opcodeI1== `OP_SW);
assign lw_opI1 = (opcodeI1== `OP_LW);
assign alu_opI1 = (opcodeI1== `OP_REG) & (
	(funcI1[5:3] == 3'b100)|(funcI1 == `FUNC_MULT) );
assign addi_opI1 = (opcodeI1== `OP_ADDI);
assign ori_opI1 = (opcodeI1== `OP_ORI);
assign lui_opI1 = (opcodeI1== `OP_LUI);
assign beq_opI1 = (opcodeI1== `OP_BEQ);
assign bne_opI1 = (opcodeI1== `OP_BNE);
assign branchI1 = beq_opI1 | bne_opI1;

assign {opcodeI0,rsI0,rtI0,rdI0,shamtI0,funcI0} = instre;
assign {opcodeI1,rsI1,rtI1,rdI1,shamtI1,funcI1} = instro;

assign rtsnd0 = addi_opI0 | ori_opI0 | lui_opI0 | lw_opI0 ;
assign rsrec1 = sw_opI1 | lw_opI1 |alu_opI1 | addi_opI1 | ori_opI1 | lui_opI1 | branchI1 ;
assign rtrec1 = sw_opI1 |alu_opI1 | branchI1 ;
assign instr1ok = !( branchI0 |
			(rsI1 == rdI0 )& rsrec1 & alu_opI0 | (rtI1 == rdI0) & rtrec1 & alu_opI0 |
			(rsI1 == rtI0) & rsrec1 & rtsnd0 | (rtI1 == rtI0) & rtrec1 & rtsnd0) ;

assign pcplus4F = pc + 4;
assign pcplus8F = pc + 8;

always @(posedge clk or negedge rst_n)  begin
	if(!rst_n) pc  <= 0;
	else if (stall) pc <= pc;
	else if (btakenD) pc <= pcbranchD;
	else if (instr1ok) pc <= pcplus8F;
	else pc <= pcplus4F;
end

always @(posedge clk or negedge rst_n)  begin
	if(!rst_n) pcplus4D  <= 0;
	else if (stall) pcplus4D <= pcplus4D;
	else if (instr1ok) pcplus4D <= pcplus8F;
	else pcplus4D <= pcplus4F;
end

always @(posedge clk or negedge rst_n)  begin
	if(!rst_n) slot <= 0;
	else if(( branchD0 | branchD1)& !stall & !slot) slot <= 1;
	else slot <= 0;
end

always @(posedge clk or negedge rst_n) 
begin 
   if(!rst_n) begin instrD0 <= 0; instrD1 <= 0; end
   else if(stall) begin instrD0 <= instrD0; instrD1 <= instrD1; end
//   else if(slot) begin instrD0 <= 0; instrD1 <= 0; end
   else if(instr1ok) begin instrD0 <= instre; instrD1 <= instro; end
   else begin instrD0 <= instre; instrD1 <= 0; end
end

/*  Instruction Decode Stage */

wire [`REG_W-1:0] rsD0, rdD0, rtD0, cadrW0;
wire [`OPCODE_W-1:0] opcodeD0;
wire [`SHAMT_W-1:0] shamtD0;
wire [`OPCODE_W-1:0] funcD0;
wire sw_opD0, addi_opD0, lw_opD0, alu_opD0;
wire lui_opD0, ori_opD0, beq_opD0, bne_opD0 ;
wire regwriteD0, memtoregD0;
wire [`OPCODE_W-1:0] alucomD0;
wire [`IMM_W-1:0] immD0;
reg [`REG_W-1:0] writeregW0;
wire [`DATA_W-1:0] rd1D0, rd2D0, rd1fD0, rd2fD0;
wire memwriteD0;
reg [`REG_W-1:0] rsE0, rtE0, rdE0;
wire [`DATA_W-1:0] signimmD0;
reg [`DATA_W-1:0] signimmE0, rd1E0, rd2E0;
wire [`DATA_W-1:0] resultW0;
reg [`OPCODE_W-1:0] alucomE0;
reg regwriteE0, memtoregE0, alusrcE0, regdstE0;
reg memtoregM0;
reg memwriteE0;
reg regwriteW0;
reg [`REG_W-1:0] writeregM0;
reg regwriteM0;
reg [`DATA_W-1:0] aluoutM0;
wire [`REG_W-1:0] writeregE0;
wire lwstall0, branchstall0;

wire [`REG_W-1:0] writeregE1;
wire [`REG_W-1:0] rsD1, rdD1, rtD1, cadrW1;
wire [`OPCODE_W-1:0] opcodeD1;
wire [`SHAMT_W-1:0] shamtD1;
wire [`OPCODE_W-1:0] funcD1;
wire sw_opD1, addi_opD1, lw_opD1, alu_opD1;
wire lui_opD1, ori_opD1, beq_opD1, bne_opD1 ;
wire regwriteD1, memtoregD1;
wire [`OPCODE_W-1:0] alucomD1;
wire [`IMM_W-1:0] immD1;
reg [`REG_W-1:0] writeregW1;
wire [`DATA_W-1:0] rd1D1, rd2D1, rd1fD1, rd2fD1;
wire memwriteD1;
reg [`REG_W-1:0] rsE1, rtE1, rdE1;
wire [`DATA_W-1:0] signimmD1;
reg [`DATA_W-1:0] signimmE1, rd1E1, rd2E1;
wire [`DATA_W-1:0] resultW1;
reg [`OPCODE_W-1:0] alucomE1;
reg regwriteE1, memtoregE1, alusrcE1, regdstE1;
reg memtoregM1;
reg regwriteM1;
reg memwriteE1;
reg [`REG_W-1:0] writeregM1;
reg [`DATA_W-1:0] aluoutM1;
reg regwriteW1;
wire lwstall1, branchstall1;

assign sw_opD0 = (opcodeD0 == `OP_SW);
assign lw_opD0 = (opcodeD0 == `OP_LW);
assign alu_opD0 = (opcodeD0 == `OP_REG) & (
     (funcD0[5:3] == 3'b100)|(funcD0 == `FUNC_MULT) );
assign addi_opD0 = (opcodeD0 == `OP_ADDI);
assign ori_opD0 = (opcodeD0 == `OP_ORI);
assign lui_opD0 = (opcodeD0 == `OP_LUI);
assign beq_opD0 = (opcodeD0 == `OP_BEQ);
assign bne_opD0 = (opcodeD0 == `OP_BNE);
assign branchD0 = beq_opD0 | bne_opD0;

assign sw_opD1 = (opcodeD1== `OP_SW);
assign lw_opD1 = (opcodeD1== `OP_LW);
assign alu_opD1 = (opcodeD1== `OP_REG) & (
     (funcD1[5:3] == 3'b100)|(funcD1 == `FUNC_MULT) );
assign addi_opD1 = (opcodeD1== `OP_ADDI);
assign ori_opD1 = (opcodeD1== `OP_ORI);
assign lui_opD1 = (opcodeD1== `OP_LUI);
assign beq_opD1 = (opcodeD1== `OP_BEQ);
assign bne_opD1 = (opcodeD1== `OP_BNE);
assign branchD1 = beq_opD1 | bne_opD1;
assign instrD0s = slot ? 0 : instrD0;
assign instrD1s = slot ? 0 : instrD1;
assign {opcodeD0, rsD0, rtD0, rdD0, shamtD0, funcD0} = instrD0s;
assign immD0 = instrD0s[`IMM_W-1:0];
assign {opcodeD1, rsD1, rtD1, rdD1, shamtD1, funcD1} = instrD1s;
assign immD1 = instrD1s[`IMM_W-1:0];

assign memwriteD0 = sw_opD0;
assign memwriteD1 = sw_opD1;

rfile rfile_1(.clk(clk), .rd1(rd1D0), .a1(rsD0), .rd2(rd2D0), .a2(rtD0),
    .wd3(resultW0), .a3(writeregW0), .we3(regwriteW0),
	.rd4(rd1D1), .a4(rsD1), .rd5(rd2D1), .a5(rtD1),
    .wd6(resultW1), .a6(writeregW1), .we6(regwriteW1));

assign alucomD0 = (addi_opD0|lw_opD0|sw_opD0) ? 
		`ALU_ADD: ori_opD0 ? `ALU_OR:
		(lui_opD0) ? `ALU_THB: funcD0;

assign regwriteD0 = lw_opD0 | alu_opD0 | lui_opD0 | addi_opD0 | ori_opD0 ;
assign memtoregD0 = lw_opD0 ;

assign alucomD1 = (addi_opD1|lw_opD1|sw_opD1) ? 
		`ALU_ADD: ori_opD1 ? `ALU_OR:
		(lui_opD1) ? `ALU_THB: funcD1;

assign regwriteD1 = lw_opD1 | alu_opD1 | lui_opD1 | addi_opD1 | ori_opD1 ;
assign memtoregD1 = lw_opD1 ;

// Stall
assign lwstall0 = ( ( (rsD0 == rtE0) | (rtD0 == rtE0) ) & memtoregE0 ) | 
					( ( (rsD0 == rtE1) | (rtD0 == rtE1) ) & memtoregE1 )  ;
assign lwstall1 = ( ( (rsD1 == rtE0) | (rtD1 == rtE0) ) & memtoregE0 ) | 
					( ( (rsD1 == rtE1) | (rtD1 == rtE1) ) & memtoregE1 )  ;
assign branchstall0 = (branchD0 & regwriteE0 & (writeregE0 == rsD0 | writeregE0 == rtD0)) |
				(branchD0 & memtoregM0 & (writeregM0 == rsD0 | writeregM0 == rtD0)) |
					(branchD0 & regwriteE1 & (writeregE1 == rsD0 | writeregE1 == rtD0)) |
				(branchD0 & memtoregM1 & (writeregM1 == rsD0 | writeregM1 == rtD0)) ;
assign branchstall1 = (branchD1 & regwriteE0 & (writeregE0 == rsD1 | writeregE0 == rtD1)) |
				(branchD1 & memtoregM0 & (writeregM0 == rsD1 | writeregM0 == rtD1)) |
					(branchD1 & regwriteE1 & (writeregE1 == rsD1 | writeregE1 == rtD1)) |
				(branchD1 & memtoregM1 & (writeregM1 == rsD1 | writeregM1 == rtD1)) ;

assign stall = lwstall0 | lwstall1 | branchstall0 | branchstall1 ;

// Forwarding
assign rd1fD0 = (rsD0 !=0) & (rsD0 == writeregM0) & regwriteM0  ? aluoutM0: 
					(rsD0 !=0) & (rsD0 == writeregM1) & regwriteM1  ? aluoutM1: rd1D0 ;
assign rd2fD0 = (rtD0 !=0) & (rtD0 == writeregM0) & regwriteM0  ? aluoutM0: 
					(rtD0 !=0) & (rtD0 == writeregM1) & regwriteM1  ? aluoutM1: rd2D0 ;
assign rd1fD1 = (rsD1 !=0) & (rsD1 == writeregM0) & regwriteM0  ? aluoutM0: 
					(rsD1 !=0) & (rsD0 == writeregM1) & regwriteM1  ? aluoutM1: rd1D1 ;
assign rd2fD1 = (rtD1 !=0) & (rtD1 == writeregM0) & regwriteM0  ? aluoutM0: 
					(rtD1 !=0) & (rtD1 == writeregM1) & regwriteM1  ? aluoutM1: rd2D1 ;

// Branch
assign btakenD = (beq_opD0 & (rd1fD0 == rd2fD0) | bne_opD0 & (rd1fD0 != rd2fD0)) |
                  (beq_opD1 & (rd1fD1 == rd2fD1) | bne_opD1 & (rd1fD1 != rd2fD1)) ;

assign signimmD0 = ori_opD0 ?  {16'b0,immD0} : 
				lui_opD0 ? {immD0, 16'b0} : 
				{{16{immD0[15]}},immD0} ;

assign signimmD1 = ori_opD1 ?  {16'b0,immD1} : 
				lui_opD1 ? {immD1, 16'b0} : 
				{{16{immD1[15]}},immD1} ;

assign pcbranchD = btakenD & branchD0 ? pcplus4D + {signimmD0[29:0],2'b00}:
					pcplus4D + {signimmD1[29:0],2'b00};

// Pipeline data register 
always @(posedge clk) begin
  if(!stall) begin
	rd1E0 <= rd1fD0;
	rd2E0 <= rd2fD0; 
	signimmE0 <= signimmD0;
	alucomE0 <= alucomD0;
	alusrcE0 <= ~alu_opD0;
	regdstE0 <= alu_opD0;  
	rd1E1 <= rd1fD1;
	rd2E1 <= rd2fD1; 
	signimmE1 <= signimmD1;
	alucomE1 <= alucomD1;
	alusrcE1 <= ~alu_opD1;
	regdstE1 <= alu_opD1;  end
end

// Pipeline control register with reset
always @(posedge clk or negedge rst_n) begin
	if(!rst_n) begin
		rsE0 <= 0;
		rtE0 <= 0;
		rdE0 <= 0;
		memtoregE0 <= 0;
		regwriteE0 <= 0;
		memwriteE0 <= 0; end
	else if(stall) begin
		rsE0 <= 0;
		rtE0 <= 0;
		rdE0 <= 0;
		memtoregE0 <= 0;
		regwriteE0 <= 0;
		memwriteE0 <= 0; end
	else begin
		rsE0 <= rsD0;
		rtE0 <= rtD0;
		rdE0 <= rdD0;
		memtoregE0 <= memtoregD0;
		regwriteE0 <= regwriteD0;
		memwriteE0 <= memwriteD0; end
end

always @(posedge clk or negedge rst_n) begin
	if(!rst_n) begin
		rsE1 <= 0;
		rtE1 <= 0;
		rdE1 <= 0;
		memtoregE1 <= 0;
		regwriteE1 <= 0;
		memwriteE1 <= 0; end
	else if(stall) begin
		rsE1 <= 0;
		rtE1 <= 0;
		rdE1 <= 0;
		memtoregE1 <= 0;
		regwriteE1 <= 0;
		memwriteE1 <= 0; end
	else begin
		rsE1 <= rsD1;
		rtE1 <= rtD1;
		rdE1 <= rdD1;
		memtoregE1 <= memtoregD1;
		regwriteE1 <= regwriteD1;
		memwriteE1 <= memwriteD1; end
end

/* Execution Stage */

wire [`DATA_W-1:0] srcaE0, writedataE0, srcbE0, aluoutE0;
reg [`DATA_W-1:0] writedataM0;
reg memwriteM0;
wire [`DATA_W-1:0] srcaE1, writedataE1, srcbE1, aluoutE1;
reg [`DATA_W-1:0] writedataM1;
reg memwriteM1;

// Forwarding 
assign srcaE0 = regwriteM0 & rsE0!=0 & writeregM0 == rsE0  ? aluoutM0 :
				regwriteW0 & rsE0!=0 & writeregW0 == rsE0 ? resultW0 : 
				regwriteM1 & rsE0!=0 & writeregM1 == rsE0  ? aluoutM1 :
				regwriteW1 & rsE0!=0 & writeregW1 == rsE0 ? resultW1 : rd1E0;
assign srcaE1 = regwriteM0 & rsE1!=0 & writeregM0 == rsE1  ? aluoutM0 :
				regwriteW0 & rsE1!=0 & writeregW0 == rsE1 ? resultW0 : 
				regwriteM1 & rsE1!=0 & writeregM1 == rsE1  ? aluoutM1 :
				regwriteW1 & rsE1!=0 & writeregW1 == rsE1 ? resultW1 : rd1E1;

assign writedataE0 = regwriteM0 & rtE0!=0 & writeregM0 == rtE0 ? aluoutM0 :
				regwriteW0 & rtE0!=0 & writeregW0 == rtE0 ? resultW0 : 
				regwriteM1 & rtE0!=0 & writeregM1 == rtE0 ? aluoutM1 :
				regwriteW1 & rtE0!=0 & writeregW1 == rtE0 ? resultW1 : rd2E0;

assign writedataE1 = regwriteM0 & rtE1!=0 & writeregM0 == rtE1 ? aluoutM0 :
				regwriteW0 & rtE1!=0 & writeregW0 == rtE1 ? resultW0 : 
				regwriteM1 & rtE1!=0 & writeregM1 == rtE1 ? aluoutM1 :
				regwriteW1 & rtE1!=0 & writeregW1 == rtE1 ? resultW1 : rd2E1;

assign srcbE0 = alusrcE0 ? signimmE0 : writedataE0;
assign srcbE1 = alusrcE1 ? signimmE1 : writedataE1;
assign writeregE0 = regdstE0 ? rdE0: rtE0;
assign writeregE1 = regdstE1 ? rdE1: rtE1;

alu alu_0(.a(srcaE0), .b(srcbE0), .s(alucomE0), .y(aluoutE0));
alu alu_1(.a(srcaE1), .b(srcbE1), .s(alucomE1), .y(aluoutE1));

// Pipeline register 
always @(posedge clk) begin
		aluoutM0 <= aluoutE0;
		memtoregM0 <= memtoregE0;
		writedataM0 <= writedataE0;
		writeregM0 <= writeregE0; 
end
always @(posedge clk) begin
		aluoutM1 <= aluoutE1;
		memtoregM1 <= memtoregE1;
		writedataM1 <= writedataE1;
		writeregM1 <= writeregE1; 
end

// Pipeline control register with reset
always @(posedge clk or negedge rst_n) begin
	if(!rst_n) begin
		regwriteM0 <= 0;
		memwriteM0 <= 0; end
	else begin
		regwriteM0 <= regwriteE0;
		memwriteM0 <= memwriteE0; end
end

always @(posedge clk or negedge rst_n) begin
	if(!rst_n) begin
		regwriteM1 <= 0;
		memwriteM1 <= 0; end
	else begin
		regwriteM1 <= regwriteE1;
		memwriteM1 <= memwriteE1; end
end
/* Memory Stage */

reg [`DATA_W-1:0] readdataW0, aluoutW0;
reg memtoregW0;
assign aluout0 = aluoutM0;
assign writedata0 = writedataM0;
assign memwrite0 = memwriteM0;
reg [`DATA_W-1:0] readdataW1, aluoutW1;
reg memtoregW1;
assign aluout1 = aluoutM1;
assign writedata1 = writedataM1;
assign memwrite1 = memwriteM1;

always @(posedge clk) begin
	readdataW0 <= readdata0;
	aluoutW0 <= aluoutM0;
	memtoregW0 <= memtoregM0;
	writeregW0 <= writeregM0;
end

always @(posedge clk) begin
	readdataW1 <= readdata1;
	aluoutW1 <= aluoutM1;
	memtoregW1 <= memtoregM1;
	writeregW1 <= writeregM1;
end

always @(posedge clk or negedge rst_n) begin
	if(!rst_n) 
		regwriteW0 <= 0;
	else 
		regwriteW0 <= regwriteM0;
end

always @(posedge clk or negedge rst_n) begin
	if(!rst_n) 
		regwriteW1 <= 0;
	else 
		regwriteW1 <= regwriteM1;
end

/* Write Back Stage */
assign resultW0 = memtoregW0 ? readdataW0: aluoutW0;
assign resultW1 = memtoregW1 ? readdataW1: aluoutW1;

endmodule
