`include "def.h"
module dmem (
 input clk,
 input [15:0] a0, a1,
 output [`DATA_W-1:0] rd0,rd1,
 input [`DATA_W-1:0] wd0,wd1,
 input  we0, we1);

	reg [`DATA_W-1:0] mem[0:`DEPTH-1];

	assign rd0 = mem[a0];
	assign rd1 = mem[a1];

	always @(posedge clk)  begin
		if(we0 & !we1) mem[a0] <= wd0;
		else if(!we0 & we1) mem[a1] <= wd1;
		else if(we0 & we1) begin
			if (a0==a1) mem[a0] <= wd0;
			else begin mem[a0] <= wd0; mem[a1] <= wd1; end
		end
	end
	initial
      begin
           $readmemh("dmem.dat", mem);
    end


endmodule
